/*
 * Decompiled with CFR 0.152.
 */
package tern.metadata;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import tern.metadata.TernModuleMetadata;
import tern.repository.ITernRepository;

public class TernModuleMetadataManager {
    private static final String METADATA_DIR = "metadata";
    private static final String METADATA_JSON_EXT = ".metadata.json";
    private final Map<String, TernModuleMetadata> metadatas = new HashMap<String, TernModuleMetadata>();
    private final File baseDir;

    public TernModuleMetadataManager(ITernRepository repository) {
        this(repository.getBaseDir());
    }

    public TernModuleMetadataManager(File baseDir) {
        this.baseDir = baseDir;
    }

    public TernModuleMetadata getMetadata(String moduleName) {
        this.initializeIfNeeded();
        return this.metadatas.get(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNeeded() {
        if (this.metadatas.size() == 0) {
            Map<String, TernModuleMetadata> map = this.metadatas;
            synchronized (map) {
                File metadataDir;
                if (this.metadatas.size() == 0 && (metadataDir = new File(this.baseDir, METADATA_DIR)).exists() && metadataDir.isDirectory()) {
                    File[] files = metadataDir.listFiles();
                    File file = null;
                    TernModuleMetadata metadata = null;
                    int i = 0;
                    while (i < files.length) {
                        file = files[i];
                        try {
                            metadata = TernModuleMetadataManager.loadMetadata(file);
                            if (metadata != null) {
                                this.metadatas.put(metadata.getName(), metadata);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public static TernModuleMetadata loadMetadata(File moduleDir, String moduleName) throws IOException {
        if (moduleDir.exists() && moduleDir.isDirectory()) {
            File metadataDir;
            String metadaFilename = moduleName + METADATA_JSON_EXT;
            File metadaFile = new File(moduleDir, metadaFilename);
            if (!metadaFile.exists() && (metadataDir = new File(moduleDir, METADATA_DIR)).exists() && metadataDir.isDirectory()) {
                metadaFile = new File(metadataDir, metadaFilename);
            }
            try {
                return TernModuleMetadataManager.loadMetadata(metadaFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static TernModuleMetadata loadMetadata(File file) throws IOException {
        if (file.isFile() && file.getName().endsWith(METADATA_JSON_EXT)) {
            JsonObject json = Json.parse((Reader)new FileReader(file)).asObject();
            return new TernModuleMetadata(json, file);
        }
        return null;
    }
}

