/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.lint;

import tern.TernException;
import tern.server.ITernPlugin;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernQuery;
import tern.utils.TernModuleHelper;

public class TernLintQuery
extends TernQuery {
    private static final long serialVersionUID = 1L;
    private static final String FULL_EXTENSION = "-full";
    private static final String GROUP_BY_FILES_NAME = "groupByFiles";
    private static final String LINE_NUMBER_NAME = "lineNumber";
    private final ITernPlugin linter;
    private boolean useLinterAsSuffix;

    private TernLintQuery(String type, ITernPlugin linter, boolean full) {
        super(full ? type + FULL_EXTENSION : type);
        if (full) {
            this.setGroupByFiles(true);
        }
        this.linter = linter;
    }

    public static TernLintQuery create(ITernPlugin plugin, boolean full) throws TernException {
        if (!plugin.isLinter()) {
            throw new TernException(String.valueOf(plugin.getName()) + " is not a linter");
        }
        TernLintQuery query = new TernLintQuery(plugin.getName(), plugin, full);
        query.setUseLinterAsSuffix(true);
        return query;
    }

    public void setGroupByFiles(boolean groupByFiles) {
        super.set(GROUP_BY_FILES_NAME, groupByFiles);
    }

    public boolean isGroupByFiles() {
        return JsonHelper.getBoolean(this, GROUP_BY_FILES_NAME, false);
    }

    public void setLineNumber(boolean lineNumber) {
        super.set(LINE_NUMBER_NAME, lineNumber);
    }

    public boolean isLineNumber() {
        return JsonHelper.getBoolean(this, LINE_NUMBER_NAME, false);
    }

    public void setUseLinterAsSuffix(boolean useLinterAsSuffix) {
        this.useLinterAsSuffix = useLinterAsSuffix;
    }

    public boolean isUseLinterAsSuffix() {
        return this.useLinterAsSuffix;
    }

    public String formatMessage(String message) {
        if (this.useLinterAsSuffix) {
            return "[" + TernModuleHelper.getLabel(this.linter) + "]" + ": " + message;
        }
        return message;
    }
}

