/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.lint;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintQuery;

public class TernLintResultProcessor
implements ITernResultProcessor<ITernLintCollector> {
    private static final String FILE_FIELD = "file";
    private static final String LINE_NUMBER_FIELD = "lineNumber";
    private static final String TO_FIELD = "to";
    private static final String FROM_FIELD = "from";
    private static final String SEVERITY_FIELD = "severity";
    private static final String MESSAGE_FIELD = "message";
    public static final TernLintResultProcessor INSTANCE = new TernLintResultProcessor();

    @Override
    public void process(TernDoc doc, IJSONObjectHelper jsonObjectHelper, Object jsonObject, ITernLintCollector collector) {
        block10: {
            if (!(jsonObject instanceof JsonObject)) {
                return;
            }
            JsonArray messages = (JsonArray)((JsonObject)jsonObject).get("messages");
            if (messages == null) break block10;
            TernLintQuery query = (TernLintQuery)doc.getQuery();
            if (query.isGroupByFiles()) {
                JsonObject filesObject = null;
                String file = null;
                for (JsonValue files : messages) {
                    filesObject = (JsonObject)files;
                    file = jsonObjectHelper.getText(filesObject.get(FILE_FIELD));
                    try {
                        collector.startLint(file);
                        JsonArray messagesFile = (JsonArray)filesObject.get("messages");
                        if (messagesFile == null) continue;
                        this.addMessages(jsonObjectHelper, messagesFile, query, collector);
                    }
                    finally {
                        collector.endLint(file);
                    }
                }
            } else {
                String file = doc.getQuery().getFile();
                try {
                    collector.startLint(file);
                    this.addMessages(jsonObjectHelper, messages, query, collector);
                }
                finally {
                    collector.endLint(file);
                }
            }
        }
    }

    protected void addMessages(IJSONObjectHelper jsonObjectHelper, JsonArray messages, TernLintQuery query, ITernLintCollector collector) {
        String message = null;
        String severity = null;
        String file = null;
        JsonObject messageObject = null;
        for (JsonValue value : messages) {
            messageObject = (JsonObject)value;
            message = query.formatMessage(jsonObjectHelper.getText(messageObject.get(MESSAGE_FIELD)));
            severity = jsonObjectHelper.getText(messageObject.get(SEVERITY_FIELD));
            Long startCh = jsonObjectHelper.getCh(messageObject, FROM_FIELD);
            Long endCh = jsonObjectHelper.getCh(messageObject, TO_FIELD);
            Long line = jsonObjectHelper.getCh(messageObject, LINE_NUMBER_FIELD);
            file = jsonObjectHelper.getText(messageObject.get(FILE_FIELD));
            collector.addMessage(message, startCh, endCh, line, severity, file);
        }
    }
}

