/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.util;

import com.liferay.ide.core.templates.ITemplateContext;
import com.liferay.ide.core.templates.ITemplateOperation;
import com.liferay.ide.core.templates.TemplatesCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.LayoutTplCore;
import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.ArrayStack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutTplUtil {
    private static void createLayoutTplContext(ITemplateOperation op, LayoutTplElement layouttpl) {
        ITemplateContext ctx = op.getContext();
        ctx.put("root", (Object)layouttpl);
        ctx.put("stack", (Object)new ArrayStack());
    }

    public static IDOMElement[] findChildElementsByClassName(IDOMElement parentElement, String childElementTag, String className) {
        if (parentElement == null || !parentElement.hasChildNodes()) {
            return null;
        }
        ArrayList<IDOMElement> childElements = new ArrayList<IDOMElement>();
        List<Element> divChildren = LayoutTplUtil.getChildElementsByTagName(parentElement, childElementTag);
        int i = 0;
        while (i < divChildren.size()) {
            IDOMElement childDivElement = (IDOMElement)divChildren.get(i);
            if (LayoutTplUtil.hasClassName(childDivElement, className)) {
                childElements.add(childDivElement);
            }
            ++i;
        }
        return childElements.toArray(new IDOMElement[0]);
    }

    public static IDOMElement findMainContentElement(IDOMDocument rootDocument) {
        if (rootDocument == null || !rootDocument.hasChildNodes()) {
            return null;
        }
        IDOMElement mainContentElement = null;
        mainContentElement = (IDOMElement)rootDocument.getElementById("main-content");
        return mainContentElement;
    }

    public static List<Element> getChildElementsByTagName(IDOMElement parentElement, String childElementTag) {
        NodeList childNodes = parentElement.getChildNodes();
        ArrayList<Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1 && childElementTag != null && (element = (Element)childNode).getTagName().equals(childElementTag)) {
                childElements.add(element);
            }
            ++i;
        }
        return childElements;
    }

    public static String getRoleValue(IDOMElement mainContentElement, String defaultValue) {
        String retval = defaultValue;
        String currentRoleValue = mainContentElement.getAttribute("role");
        if (!CoreUtil.isNullOrEmpty((String)currentRoleValue)) {
            retval = currentRoleValue;
        }
        return retval;
    }

    public static String getTemplateSource(LayoutTplElement layouttpl) {
        StringBuffer buffer = new StringBuffer();
        try {
            ITemplateOperation templateOperation = null;
            templateOperation = (Boolean)layouttpl.getBootstrapStyle().content() != false ? TemplatesCore.getTemplateOperation((String)"com.liferay.ide.layouttpl.core.layoutTemplate.bootstrap") : TemplatesCore.getTemplateOperation((String)"com.liferay.ide.layouttpl.core.layoutTemplate.legacy");
            LayoutTplUtil.createLayoutTplContext(templateOperation, layouttpl);
            templateOperation.setOutputBuffer(buffer);
            templateOperation.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            LayoutTplCore.logError("Error getting template source.", ex);
        }
        return buffer.toString();
    }

    public static int getWeightValue(IDOMElement portletColumnElement, int defaultValue) {
        int weightValue = defaultValue;
        if (portletColumnElement == null) {
            return weightValue;
        }
        String classAttr = portletColumnElement.getAttribute("class");
        if (CoreUtil.isNullOrEmpty((String)classAttr)) {
            return weightValue;
        }
        Matcher matcher = Pattern.compile("(.*span)(\\d+)").matcher(classAttr);
        if (matcher.matches()) {
            String weightString = matcher.group(2);
            if (!CoreUtil.isNullOrEmpty((String)weightString)) {
                try {
                    weightValue = Integer.parseInt(weightString);
                }
                catch (NumberFormatException numberFormatException) {
                    weightValue = 0;
                }
            }
        } else {
            String weightString;
            matcher = Pattern.compile(".*aui-w([-\\d]+).*").matcher(classAttr);
            if (matcher.matches() && !CoreUtil.isNullOrEmpty((String)(weightString = matcher.group(1)))) {
                try {
                    weightValue = Integer.parseInt(weightString);
                }
                catch (NumberFormatException numberFormatException) {
                    weightValue = 0;
                }
            }
        }
        return weightValue;
    }

    public static boolean hasClassName(IDOMElement domElement, String className) {
        String classAttr;
        boolean retval = false;
        if (domElement != null && !CoreUtil.isNullOrEmpty((String)(classAttr = domElement.getAttribute("class")))) {
            retval = classAttr.contains(className);
        }
        return retval;
    }

    public static void saveToFile(LayoutTplElement diagramElement, IFile file, IProgressMonitor monitor) {
        try {
            ITemplateOperation op = null;
            op = (Boolean)diagramElement.getBootstrapStyle().content() != false ? TemplatesCore.getTemplateOperation((String)"com.liferay.ide.layouttpl.core.layoutTemplate.bootstrap") : TemplatesCore.getTemplateOperation((String)"com.liferay.ide.layouttpl.core.layoutTemplate.legacy");
            LayoutTplUtil.createLayoutTplContext(op, diagramElement);
            op.setOutputFile(file);
            op.execute(monitor);
        }
        catch (Exception e) {
            LayoutTplCore.logError(e);
        }
    }
}

