/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.contentassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;

public class ResourceContentAssistAdditionalProposalInfoProvider
implements IContentAssistAdditionalProposalInfoProvider<IResource> {
    private static ILabelProvider WORKBENCH_LABEL_PROVIDER = null;
    public static final IContentAssistAdditionalProposalInfoProvider<IResource> INSTANCE = new ResourceContentAssistAdditionalProposalInfoProvider();

    @Override
    public Image getImage(IResource resource) {
        if (WORKBENCH_LABEL_PROVIDER == null) {
            WORKBENCH_LABEL_PROVIDER = new WorkbenchLabelProvider();
        }
        return WORKBENCH_LABEL_PROVIDER.getImage((Object)resource);
    }

    @Override
    public String getDisplayText(String displayText, IResource resource) {
        return displayText;
    }

    @Override
    public String getTextInfo(IResource resource) {
        StringBuilder buf = new StringBuilder();
        buf.append("<b>Path:</b> ");
        buf.append("/" + resource.getProject().getName() + "/" + resource.getProjectRelativePath().toString());
        buf.append("<br><b>Type:</b> ");
        switch (resource.getType()) {
            case 1: {
                buf.append("File");
                String type = this.getType((IFile)resource);
                if (StringUtils.isEmpty((String)type)) break;
                buf.append(" (");
                buf.append(type);
                buf.append(")");
                break;
            }
            case 4: {
                buf.append("Project");
                break;
            }
            case 2: {
                buf.append("Folder");
            }
        }
        buf.append("<br><b>Location:</b> ");
        buf.append(resource.getLocation().toString());
        return buf.toString();
    }

    protected String getType(IFile file) {
        try {
            IContentType contentType;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                return contentType.getName();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

