/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.contentassist;

import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.contentassist.DOMAttrContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.contentassist.DOMNodeContentAssistContext;
import org.eclipse.wst.xml.search.editor.contentassist.DOMTextContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.internal.contentassist.XMLReferencesContentAssistCalculator;
import org.eclipse.wst.xml.search.editor.internal.util.EditorUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.XMLReferencesUtil;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Node;

public class XMLReferencesContentAssistUtils {
    public static void addAttributeValueProposals(ContentAssistRequest request) {
        XMLReferencesContentAssistCalculator calculator;
        IDOMNode node = (IDOMNode)request.getNode();
        IDOMAttr selectedNode = DOMUtils.getAttrByRegion((IDOMNode)node, (ITextRegion)request.getRegion());
        if (selectedNode == null) {
            return;
        }
        String matchString = EditorUtils.prepareMatchString(request);
        IXMLReference reference = XMLReferencesUtil.getXMLReference((Node)selectedNode, selectedNode.getModel().getContentTypeIdentifier());
        if (reference != null && (calculator = new XMLReferencesContentAssistCalculator(reference, (IDOMNode)selectedNode)) != null) {
            DOMNodeContentAssistContext context = new DOMNodeContentAssistContext(request, matchString);
            DOMAttrContentAssistProposalRecorder recorder = new DOMAttrContentAssistProposalRecorder(request);
            calculator.computeProposals(context, recorder);
        }
    }

    public static void addEntityProposals(IContentAssistProcessor delegatingContentAssistProcessor, ContentAssistRequest request) {
        String textContent = "";
        IDOMNode node = (IDOMNode)request.getNode();
        IDOMText text = XMLReferencesContentAssistUtils.getDOMText(node);
        String matchString = "";
        int startOffset = request.getStartOffset();
        if (text != null) {
            textContent = matchString = text.getData();
            int replacementBeginPosition = request.getReplacementBeginPosition();
            startOffset = text.getStartOffset();
            int l = replacementBeginPosition - startOffset;
            matchString = matchString.replaceAll("\r", "");
            if ((matchString = matchString.trim()).length() > l) {
                matchString = matchString.substring(0, l);
            }
            node = text;
        }
        String prefix = null;
        String namespace = null;
        if (prefix == null && namespace == null) {
            prefix = node.getPrefix();
            namespace = node.getNamespaceURI();
        }
        XMLReferencesContentAssistUtils.computeDOMTextProposals(request, node, matchString, namespace, prefix, textContent, startOffset);
    }

    private static IDOMText getDOMText(IDOMNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            return (IDOMText)node;
        }
        if (node.getNodeType() == 1) {
            IDOMNode firstChild = (IDOMNode)node.getFirstChild();
            return firstChild == null ? null : XMLReferencesContentAssistUtils.getDOMText(firstChild);
        }
        return null;
    }

    private static void computeDOMTextProposals(ContentAssistRequest request, IDOMNode node, String matchString, String namespace, String prefix, String textContent, int startOffset) {
        XMLReferencesContentAssistCalculator calculator;
        IDOMNode selectedNode = node;
        IXMLReference reference = XMLReferencesUtil.getXMLReference((Node)selectedNode, EditorUtils.getFile(request));
        if (reference != null && (calculator = new XMLReferencesContentAssistCalculator(reference, selectedNode)) != null) {
            DOMNodeContentAssistContext context = new DOMNodeContentAssistContext(request, matchString);
            DOMTextContentAssistProposalRecorder recorder = new DOMTextContentAssistProposalRecorder(request, textContent, startOffset);
            calculator.computeProposals(context, recorder);
        }
    }
}

