/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.contentassist;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.internal.Trace;

public class ContentAssistsManager
extends AbstractRegistryManager {
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String ADDITIONAL_PROPOSAL_INFO_PROVIDER_ELT = "additionalProposalInfoProvider";
    public static final ContentAssistsManager INSTANCE = new ContentAssistsManager();
    private static final String CONTENT_ASSISTS_EXTENSION_POINT = "contentAssists";
    private Map<String, IContentAssistAdditionalProposalInfoProvider> providersById = null;

    public static ContentAssistsManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.providersById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addContentAssists(this.providersById, cf);
        }
    }

    private synchronized void addContentAssists(Map<String, IContentAssistAdditionalProposalInfoProvider> providersById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ADDITIONAL_PROPOSAL_INFO_PROVIDER_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    IContentAssistAdditionalProposalInfoProvider provider = (IContentAssistAdditionalProposalInfoProvider)ce.createExecutableExtension(CLASS_ATTR);
                    providersById.put(id, provider);
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load contentAssists for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IContentAssistAdditionalProposalInfoProvider getProvider(String referenceId) {
        if (StringUtils.isEmpty((String)referenceId)) {
            return null;
        }
        if (this.providersById == null) {
            this.loadContentAssists();
        }
        return this.providersById.get(referenceId);
    }

    private synchronized void loadContentAssists() {
        if (this.providersById != null) {
            return;
        }
        HashMap<String, IContentAssistAdditionalProposalInfoProvider<Object>> providersById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", CONTENT_ASSISTS_EXTENSION_POINT);
            providersById = new HashMap(cf.length);
            this.addContentAssists(providersById, cf);
        } else {
            providersById = new HashMap<String, IContentAssistAdditionalProposalInfoProvider>();
        }
        this.providersById = providersById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return CONTENT_ASSISTS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

