/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.EqualsStringQueryBuilder;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.IStringQueryBuilder;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.core.xpath.XPathManager;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathMatcher;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.internal.references.AbstractXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToXML;
import org.eclipse.wst.xml.search.editor.references.filters.IXMLReferenceFilter;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.w3c.dom.Node;

public class XMLReferencePath
extends AbstractXMLReferenceTo
implements IXMLReferenceToXML {
    public static final int FROM_PATH_INDEX = -9999999;
    private final String path;
    private final String[] targetNodes;
    private final XPathMatcher matcher;
    private final String keyPath;
    private final IXMLReferenceFilter filter;
    private final IContentAssistAdditionalProposalInfoProvider<?> additionalProposalInfoProvider;
    private final Namespaces namespaces;
    private Map<String, String> builtPaths = new HashMap<String, String>();
    private int nbWildCard;

    public XMLReferencePath(IReference ownerReference, String id, IXMLSearcher searcher, String path, String[] targetNodes, Namespaces namespaces, String querySpecificationId, String tokenId, IXMLReferenceFilter filter, IContentAssistAdditionalProposalInfoProvider<?> additionalProposalInfoProvider) {
        super(ownerReference, id, searcher, querySpecificationId, tokenId);
        this.targetNodes = targetNodes;
        this.namespaces = namespaces;
        this.matcher = new XPathMatcher(path);
        this.nbWildCard = this.matcher.getNbWildCard();
        this.keyPath = this.computeKeyPath(path, targetNodes);
        this.path = this.computeXPathWithWildcard(path);
        this.filter = filter;
        this.additionalProposalInfoProvider = additionalProposalInfoProvider;
    }

    private String computeXPathWithWildcard(String path) {
        if (this.nbWildCard == -1) {
            return path;
        }
        int i = 0;
        while (i < this.nbWildCard + 1) {
            path = path.replaceAll("\\$" + i, "{" + i + "}");
            ++i;
        }
        return path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String[] getTargetNodes() {
        return this.targetNodes;
    }

    @Override
    public boolean match(Node node) {
        return this.matcher.match(node);
    }

    private String getXPathFromCache(IStringQueryBuilder builder, Object selectedNode) {
        if (builder == null) {
            builder = EqualsStringQueryBuilder.INSTANCE;
        }
        if (builder.getId() == null) {
            return this.createXPath(builder, selectedNode);
        }
        String id = String.valueOf(builder.getId()) + "_" + this.nbWildCard;
        String xpath = this.builtPaths.get(id);
        if (xpath == null) {
            xpath = this.createXPath(builder, selectedNode);
            this.builtPaths.put(id, xpath);
        }
        return xpath;
    }

    private String createXPath(IStringQueryBuilder builder, Object selectedNode) {
        String p = this.path;
        int index = this.nbWildCard + 1;
        String xpath = builder.build(p, this.targetNodes, index, selectedNode);
        return xpath;
    }

    @Override
    public IXMLReferenceTo.ToType getType() {
        return IXMLReferenceTo.ToType.XML;
    }

    @Override
    public String getKeyPath() {
        return this.keyPath;
    }

    private String computeKeyPath(String path, String[] targetNodes) {
        StringBuilder result = new StringBuilder(path);
        String[] stringArray = targetNodes;
        int n = targetNodes.length;
        int n2 = 0;
        while (n2 < n) {
            String targetNode = stringArray[n2];
            result.append("_");
            result.append(targetNode);
            ++n2;
        }
        return result.toString();
    }

    @Override
    public String getQuery(Object selectedNode, String mathingString, IStringQueryBuilder builder) {
        return this.getQuery(selectedNode, mathingString, builder, true);
    }

    @Override
    public String getQuery(Object selectedNode, String mathingString, IStringQueryBuilder builder, boolean reversed) {
        String xpath = this.getXPathFromCache(builder, selectedNode);
        List<Object> values = null;
        if (this.hasWildCard()) {
            IXMLReferencePath from = ((IXMLReference)this.getOwnerReference()).getFrom();
            if (!reversed) {
                List<IXMLReferenceTo> to = this.getOwnerReference().getTo();
                for (IXMLReferenceTo referenceTo : to) {
                    if (referenceTo.getType() != IXMLReferenceTo.ToType.XML) continue;
                    values = ((IXMLReferenceToXML)referenceTo).getWildcardValues(selectedNode);
                }
            } else {
                values = from.getWildcardValues(selectedNode);
            }
        } else {
            values = new ArrayList<String>();
        }
        if (mathingString != null) {
            values.add(mathingString);
        } else if (selectedNode instanceof Node) {
            values.add(DOMUtils.getNodeValue((Node)((Node)selectedNode)));
        }
        return XPathManager.getManager().getXPath(xpath, values.toArray(StringUtils.EMPTY_ARRAY));
    }

    @Override
    public List<String> getWildcardValues(Object selectedNode) {
        if (selectedNode instanceof Node) {
            return this.matcher.getWildcardValues((Node)selectedNode);
        }
        return null;
    }

    @Override
    public IContentAssistAdditionalProposalInfoProvider<?> getAdditionalProposalInfoProvider() {
        return this.additionalProposalInfoProvider;
    }

    @Override
    public IXMLReferenceFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasWildCard() {
        return this.nbWildCard != -1;
    }

    @Override
    public Namespaces getNamespaces() {
        return this.namespaces;
    }
}

