/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferenceContainer;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencePathFactory;
import org.eclipse.wst.xml.search.editor.internal.references.validators.XMLReferenceValidatorsManager;
import org.eclipse.wst.xml.search.editor.internal.searchers.expressions.XMLExpressionParserManager;
import org.eclipse.wst.xml.search.editor.references.AbstractReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.validators.DefaultDOMNodeValidator;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.XMLSearcherManager;
import org.eclipse.wst.xml.search.editor.searchers.expressions.IXMLExpressionParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLReferencesManager
extends AbstractReferencesManager<IXMLReference, Node> {
    private static final String XPATH_FACTORY_ID_ATTR = "xpathFactoryId";
    private static final String VALIDATOR_ID_ATTR = "validatorId";
    private static final String PARSER_ID_ATTR = "parserId";
    private static final String SEARCHER_ID_ATTR = "searcherId";
    private static final String DEFAULT_SEARCHER_FOR_EXPRESSION = "org.eclipse.wst.xml.search.editor.searcher.expression";
    private static final XMLReferencesManager INSTANCE = new XMLReferencesManager();
    private static final String XML_REFERENCES_EXTENSION_POINT = "xmlReferences";
    private Map<String, XMLReferenceContainer> referencesContainerByContentTypeId = null;
    private Collection<String> contentTypeIds = null;

    public static XMLReferencesManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IXMLReference getXMLReference(Node node, String contentTypeId) {
        if (node == null) {
            return null;
        }
        Collection<IXMLReference> references = this.getXMLReferences(node, Direction.FROM, contentTypeId);
        if (references == null) {
            return null;
        }
        Node testNode = this.getTestNode(node);
        for (IXMLReference reference : references) {
            if (!this.match(testNode, node, reference.getFrom())) continue;
            return reference;
        }
        return null;
    }

    private Node getTestNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return ((Text)node).getParentNode();
            }
        }
        return node;
    }

    public boolean match(Node node, IXMLReferencePath referencePath) {
        return this.match(this.getTestNode(node), node, referencePath);
    }

    public boolean match(Node parentNode, Node node, IXMLReferencePath referencePath) {
        if (referencePath == null) {
            return false;
        }
        if (!referencePath.match(parentNode)) {
            return false;
        }
        Namespaces namespaces = referencePath.getNamespaces();
        if (namespaces == null) {
            return true;
        }
        if (referencePath.getTargetNodes()[0].indexOf(58) == -1) {
            return true;
        }
        return namespaces.match(node);
    }

    public Collection<IXMLReference> getXMLReferences(Node node, Direction direction, String contentTypeId) {
        this.loadXMLReferencesIfNeeded();
        if (contentTypeId == null) {
            ArrayList<IXMLReference> references = new ArrayList<IXMLReference>();
            Collection<XMLReferenceContainer> containers = this.referencesContainerByContentTypeId.values();
            for (XMLReferenceContainer container : containers) {
                Collection<IXMLReference> referencesByContainer = container.getXMLReferences(node, direction);
                if (referencesByContainer == null) continue;
                references.addAll(referencesByContainer);
            }
            return references;
        }
        XMLReferenceContainer container = this.getXMLReferenceContainer(contentTypeId);
        return container == null ? null : container.getXMLReferences(node, direction);
    }

    private IContentType getParentType(String contentTypeId) {
        IContentType type;
        if (contentTypeId != null && (type = Platform.getContentTypeManager().getContentType(contentTypeId)) != null) {
            return type.getBaseType();
        }
        return null;
    }

    public List<IXMLReference> getXMLReferenceInversed(Node node, String contentTypeId) {
        if (node == null) {
            return null;
        }
        Collection<IXMLReference> references = this.getXMLReferences(node, Direction.TO, null);
        if (references == null) {
            return null;
        }
        ArrayList<IXMLReference> matchedPaths = null;
        Node parentNode = this.getTestNode(node);
        for (IXMLReference reference : references) {
            List<IXMLReferenceTo> to = reference.getTo();
            for (IXMLReferenceTo referenceTo : to) {
                IXMLReferencePath referencePath;
                if (referenceTo.getType() != IXMLReferenceTo.ToType.XML || !this.match(parentNode, node, referencePath = (IXMLReferencePath)referenceTo)) continue;
                if (matchedPaths == null) {
                    matchedPaths = new ArrayList<IXMLReference>();
                }
                if (matchedPaths.contains(reference)) continue;
                matchedPaths.add(reference);
            }
        }
        return matchedPaths;
    }

    public Collection<IXMLReferencePath> getXMLReferencesByPathTo(String path, String contentTypeId) {
        ArrayList<IXMLReferencePath> referencePaths = new ArrayList<IXMLReferencePath>();
        Collection<XMLReferenceContainer> containers = this.referencesContainerByContentTypeId.values();
        for (XMLReferenceContainer container : containers) {
            Collection<IXMLReferencePath> o = container.getXMLReferencesByPathTo(path);
            if (o == null) continue;
            referencePaths.addAll(o);
        }
        return referencePaths;
    }

    private synchronized void loadXMLReferences() {
        if (this.referencesContainerByContentTypeId != null) {
            return;
        }
        this.contentTypeIds = new ArrayList<String>();
        HashMap<String, XMLReferenceContainer> referencesContainerByContentTypeId = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor(this.getPluginId(), XML_REFERENCES_EXTENSION_POINT);
            referencesContainerByContentTypeId = new HashMap();
            this.addXMLReferences(referencesContainerByContentTypeId, cf);
        } else {
            referencesContainerByContentTypeId = new HashMap<String, XMLReferenceContainer>();
        }
        this.referencesContainerByContentTypeId = referencesContainerByContentTypeId;
        super.addRegistryListenerIfNeeded();
    }

    private synchronized void addXMLReferences(Map<String, XMLReferenceContainer> referencesContainerByContentTypeId, IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("references".equals(ce.getName())) {
                String ids = ce.getAttribute("contentTypeIds");
                String[] defaultContentTypeIds = ids != null ? ids.split(",") : StringUtils.EMPTY_ARRAY;
                String contentTypeId = null;
                int i = 0;
                while (i < defaultContentTypeIds.length) {
                    contentTypeId = defaultContentTypeIds[i];
                    if (!this.contentTypeIds.contains(contentTypeId)) {
                        this.contentTypeIds.add(contentTypeId);
                    }
                    ++i;
                }
                String xpathFactoryId = ce.getAttribute(XPATH_FACTORY_ID_ATTR);
                IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement referenceDecl = iConfigurationElementArray2[n4];
                    this.parseReferenceDecl(referenceDecl, defaultContentTypeIds, xpathFactoryId, referencesContainerByContentTypeId);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void parseReferenceDecl(IConfigurationElement referenceDecl, String[] defaultContentTypeIds, String defaultXpathFactoryId, Map<String, XMLReferenceContainer> referencesContainerByContentTypeId) {
        try {
            IXMLReference reference = null;
            IXMLReferenceTo referenceTo = null;
            IXMLReferenceValidator validator = this.getValidator(referenceDecl);
            if (validator == null) {
                validator = DefaultDOMNodeValidator.INSTANCE;
            }
            IXMLExpressionParser parser = this.getParser(referenceDecl);
            IXMLSearcher expressionSearcher = this.getSearcher(referenceDecl, DEFAULT_SEARCHER_FOR_EXPRESSION);
            IConfigurationElement[] iConfigurationElementArray = referenceDecl.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement fromOrTo = iConfigurationElementArray[n2];
                if ("from".equals(fromOrTo.getName())) {
                    reference = XMLReferencePathFactory.INSTANCE.createReference(fromOrTo, defaultContentTypeIds, validator, parser, expressionSearcher);
                } else if (reference != null && (referenceTo = XMLReferencePathFactory.INSTANCE.createTo(fromOrTo, reference)) != null) {
                    reference.addTo(referenceTo);
                }
                ++n2;
            }
            if (reference != null) {
                this.registerXMLReference(reference, referencesContainerByContentTypeId);
            }
        }
        catch (Throwable t) {
            Trace.trace((byte)3, "  Could not load references", t);
        }
    }

    private IXMLReferenceValidator getValidator(IConfigurationElement element) {
        String validatorId = element.getAttribute(VALIDATOR_ID_ATTR);
        if (StringUtils.isEmpty((String)validatorId)) {
            return null;
        }
        return XMLReferenceValidatorsManager.getDefault().getProvider(validatorId);
    }

    private IXMLExpressionParser getParser(IConfigurationElement element) {
        String parserId = element.getAttribute(PARSER_ID_ATTR);
        if (StringUtils.isEmpty((String)parserId)) {
            return null;
        }
        return XMLExpressionParserManager.getDefault().getParser(parserId);
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.referencesContainerByContentTypeId == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addXMLReferences(this.referencesContainerByContentTypeId, cf);
        }
    }

    public void registerXMReference(IXMLReference reference) {
        this.loadXMLReferencesIfNeeded();
        this.registerXMLReference(reference, this.referencesContainerByContentTypeId);
    }

    private void registerXMLReference(IXMLReference reference, Map<String, XMLReferenceContainer> referencesContainerByContentTypeId) {
        String[] contentTypeIds = reference.getContentTypeIds();
        if (contentTypeIds != null) {
            String[] stringArray = contentTypeIds;
            int n = contentTypeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contentTypeId = stringArray[n2];
                XMLReferenceContainer container = referencesContainerByContentTypeId.get(contentTypeId);
                if (container == null) {
                    container = new XMLReferenceContainer(contentTypeId);
                    referencesContainerByContentTypeId.put(contentTypeId, container);
                }
                container.addReference(reference);
                ++n2;
            }
        }
    }

    protected String getExtensionPoint() {
        return XML_REFERENCES_EXTENSION_POINT;
    }

    public Collection<IXMLReference> getAllReferencesWithOneReferenceTo(IXMLReferenceTo.ToType toType) {
        this.loadXMLReferencesIfNeeded();
        ArrayList<IXMLReference> to = new ArrayList<IXMLReference>();
        Collection<XMLReferenceContainer> containers = this.referencesContainerByContentTypeId.values();
        for (XMLReferenceContainer container : containers) {
            to.addAll(container.getAllReferencesWithOneReferenceTo(toType));
        }
        return to;
    }

    public XMLReferenceContainer getXMLReferenceContainer(String contentTypeId) {
        this.loadXMLReferencesIfNeeded();
        XMLReferenceContainer container = this.referencesContainerByContentTypeId.get(contentTypeId);
        if (container == null) {
            String id = contentTypeId;
            while (container == null) {
                IContentType baseType = this.getParentType(id);
                if (baseType == null) break;
                id = baseType.getId();
                container = this.referencesContainerByContentTypeId.get(id);
            }
        }
        return container;
    }

    private void loadXMLReferencesIfNeeded() {
        if (this.referencesContainerByContentTypeId == null) {
            this.loadXMLReferences();
        }
    }

    public Collection<String> getContentTypeIds() {
        this.loadXMLReferencesIfNeeded();
        return this.contentTypeIds;
    }

    public Collection<IXMLReference> getXMLReferencesForToType(IXMLReferenceTo.ToType toType) {
        this.loadXMLReferencesIfNeeded();
        ArrayList<IXMLReference> references = new ArrayList<IXMLReference>();
        Collection<XMLReferenceContainer> containers = this.referencesContainerByContentTypeId.values();
        for (XMLReferenceContainer container : containers) {
            references.addAll(container.getXMLReferencesForToType(toType));
        }
        return references;
    }

    private IXMLSearcher getSearcher(IConfigurationElement element, String defaultSearcherId) {
        IXMLSearcher searcher;
        String searcherId = element.getAttribute(SEARCHER_ID_ATTR);
        if (searcherId == null) {
            searcherId = defaultSearcherId;
        }
        if ((searcher = XMLSearcherManager.getDefault().getSearcher(searcherId)) == null) {
            return null;
        }
        return searcher;
    }

    static enum Direction {
        FROM,
        TO;

    }
}

