/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.java;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.java.IJavaReference;
import org.eclipse.wst.xml.search.editor.java.JavaReferencePathFactory;
import org.eclipse.wst.xml.search.editor.references.AbstractReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;

public class JavaReferencesManager
extends AbstractReferencesManager<IJavaReference, IJavaElement> {
    private static final JavaReferencesManager INSTANCE = new JavaReferencesManager();
    private static final String JAVA_REFERENCES_EXTENSION_POINT = "javaReferences";
    private Collection<IJavaReference> references;

    public static JavaReferencesManager getInstance() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.references == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addJavaReferences(this.references, cf);
        }
    }

    private synchronized void addJavaReferences(Collection<IJavaReference> references, IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("references".equals(ce.getName())) {
                IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement referenceDecl = iConfigurationElementArray2[n4];
                    this.parseReferenceDecl(referenceDecl, references);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void parseReferenceDecl(IConfigurationElement referenceDecl, Collection<IJavaReference> references) {
        try {
            IJavaReference reference = null;
            IXMLReferenceTo referenceTo = null;
            IConfigurationElement[] iConfigurationElementArray = referenceDecl.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement fromOrTo = iConfigurationElementArray[n2];
                if ("from".equals(fromOrTo.getName())) {
                    reference = JavaReferencePathFactory.INSTANCE.createReference(fromOrTo);
                } else if (reference != null && (referenceTo = JavaReferencePathFactory.INSTANCE.createTo(fromOrTo, reference)) != null) {
                    reference.addTo(referenceTo);
                }
                ++n2;
            }
            if (reference != null) {
                this.registerJavaReference(reference, references);
            }
        }
        catch (Throwable t) {
            Trace.trace((byte)3, "  Could not load references", t);
        }
    }

    public void registerJavaReference(IJavaReference reference) {
        this.loadJavaReferencesIfNeeded();
        this.registerJavaReference(reference, this.references);
    }

    private void registerJavaReference(IJavaReference reference, Collection<IJavaReference> references) {
        references.add(reference);
    }

    @Override
    public IJavaReference getXMLReference(IJavaElement node, String contentTypeId) {
        this.loadJavaReferencesIfNeeded();
        for (IJavaReference reference : this.references) {
            if (!reference.match(node)) continue;
            return reference;
        }
        return null;
    }

    private void loadJavaReferencesIfNeeded() {
        if (this.references == null) {
            this.loadJavaReferences();
        }
    }

    private synchronized void loadJavaReferences() {
        if (this.references != null) {
            return;
        }
        ArrayList<IJavaReference> references = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor(this.getPluginId(), JAVA_REFERENCES_EXTENSION_POINT);
            references = new ArrayList(cf.length);
            this.addJavaReferences(references, cf);
        } else {
            references = new ArrayList<IJavaReference>();
        }
        this.references = references;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return JAVA_REFERENCES_EXTENSION_POINT;
    }
}

