/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.javamethod;

import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.XMLSearchEditorPlugin;
import org.eclipse.wst.xml.search.editor.internal.hyperlink.JavaElementHyperlink;
import org.eclipse.wst.xml.search.editor.internal.util.EditorUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToJavaMethod;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestor;
import org.eclipse.wst.xml.search.editor.util.JdtUtils;
import org.eclipse.wst.xml.search.editor.validation.DefaultValidationResult;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLSearcherForJavaMethod
implements IXMLSearcher {
    public static final IXMLSearcher INSTANCE = new XMLSearcherForJavaMethod();

    @Override
    public void searchForCompletion(Object selectedNode, String mathingString, String forceBeforeText, String forceEndText, IFile file, IXMLReferenceTo referenceTo, IContentAssistProposalRecorder recorder) {
        IXMLReferenceToJavaMethod toJavaMethod = (IXMLReferenceToJavaMethod)referenceTo;
        try {
            String[] classNames = this.getClassNames(selectedNode, file, referenceTo);
            if (classNames == null || classNames.length == 0) {
                return;
            }
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                IType type = JdtUtils.getJavaType(file.getProject(), className);
                if (type == null) {
                    return;
                }
                IJavaMethodRequestor filter = toJavaMethod.getRequestor(selectedNode, file);
                if (filter == null) {
                    return;
                }
                try {
                    this.createCompletion(selectedNode, mathingString, recorder, type, filter);
                }
                catch (JavaModelException e) {
                    Trace.trace((byte)3, "Error while getting methods for class=" + className, e);
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void createCompletion(Object selectedNode, String mathingString, IContentAssistProposalRecorder recorder, IType type, IJavaMethodRequestor requestor) throws JavaModelException {
        if (type == null) {
            return;
        }
        IMethod method = null;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            String methodName = requestor.matchPartial(selectedNode, mathingString, method);
            if (methodName != null) {
                this.createMethodProposal(recorder, method, methodName);
            }
            ++i;
        }
        this.createCompletion(selectedNode, mathingString, recorder, JdtUtils.getSuperType(type), requestor);
    }

    @Override
    public void searchForHyperlink(Object selectedNode, int offset, String mathingString, int startOffset, int endOffset, IFile file, IXMLReferenceTo referenceTo, IRegion hyperlinkRegion, List<IHyperlink> hyperLinks, ITextEditor textEditor) {
        IXMLReferenceToJavaMethod toJavaMethod = (IXMLReferenceToJavaMethod)referenceTo;
        try {
            String[] classNames = this.getClassNames(selectedNode, file, referenceTo);
            if (classNames == null || classNames.length == 0) {
                return;
            }
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                IType type = JdtUtils.getJavaType(file.getProject(), className);
                if (type == null) {
                    return;
                }
                IJavaMethodRequestor filter = toJavaMethod.getRequestor(selectedNode, file);
                if (filter == null) {
                    return;
                }
                try {
                    String matching = mathingString;
                    this.createHyperlink(selectedNode, matching, hyperlinkRegion, hyperLinks, type, filter);
                }
                catch (JavaModelException e) {
                    Trace.trace((byte)3, "Error while getting methods for class=" + className, e);
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void createHyperlink(Object selectedNode, String matching, IRegion hyperlinkRegion, List<IHyperlink> hyperLinks, IType type, IJavaMethodRequestor requestor) throws JavaModelException {
        if (type == null) {
            return;
        }
        IMethod method = null;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            IStatus status = requestor.matchTotally(selectedNode, matching, method);
            if (status != null && status.isOK()) {
                hyperLinks.add(new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method));
            }
            ++i;
        }
        this.createHyperlink(selectedNode, matching, hyperlinkRegion, hyperLinks, JdtUtils.getSuperType(type), requestor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IValidationResult searchForValidation(Object selectedNode, String matchingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IXMLReferenceToJavaMethod toJavaMethod = (IXMLReferenceToJavaMethod)referenceTo;
        DefaultValidationResult result = new DefaultValidationResult();
        try {
            String[] classNames = this.getClassNames(selectedNode, file, referenceTo);
            if (classNames == null) return null;
            if (classNames.length == 0) {
                return null;
            }
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                String className = stringArray[n2];
                IType type = JdtUtils.getJavaType(file.getProject(), className);
                if (type == null) {
                    return null;
                }
                IJavaMethodRequestor filter = toJavaMethod.getRequestor(selectedNode, file);
                if (filter == null) {
                    return null;
                }
                try {
                    this.createValidation(selectedNode, matchingString, result, type, filter);
                }
                catch (JavaModelException e) {
                    Trace.trace((byte)3, "Error while getting methods for class=" + className, e);
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void createValidation(Object selectedNode, String matching, DefaultValidationResult result, IType type, IJavaMethodRequestor requestor) throws JavaModelException {
        if (type == null) {
            return;
        }
        IMethod method = null;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            IStatus status = requestor.matchTotally(selectedNode, matching, method);
            if (status != null && status.isOK()) {
                result.addElement();
            }
            ++i;
        }
        this.createValidation(selectedNode, matching, result, JdtUtils.getSuperType(type), requestor);
    }

    private String[] getClassNames(Object selectedNode, IFile file, IXMLReferenceTo referenceTo) throws XPathExpressionException {
        IXMLReferenceToJavaMethod toJavaMethod = (IXMLReferenceToJavaMethod)referenceTo;
        return toJavaMethod.extractClassNames(this.getOwnerNode((Node)selectedNode), file, null, null);
    }

    private Node getOwnerNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return ((Text)node).getParentNode();
            }
        }
        return node;
    }

    protected void createMethodProposal(IContentAssistProposalRecorder recorder, IMethod method, String methodNameToUse) {
        try {
            String methodName;
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString(method);
            String returnType = JdtUtils.getReturnTypeString(method, true);
            String replaceText = methodName = method.getElementName();
            StringBuilder buf = new StringBuilder();
            buf.append(replaceText);
            if (parameterTypes.length > 0 && parameterNames.length > 0) {
                buf.append(" (");
                int i = 0;
                while (i < parameterTypes.length) {
                    buf.append(parameterTypes[i]);
                    buf.append(' ');
                    buf.append(parameterNames[i]);
                    if (i < parameterTypes.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                buf.append(") ");
            } else {
                buf.append("() ");
            }
            if (returnType != null) {
                buf.append(Signature.getSimpleName((String)returnType));
                buf.append(" - ");
            } else {
                buf.append(" void - ");
            }
            buf.append(method.getParent().getElementName());
            String displayText = buf.toString();
            Image image = XMLSearchEditorPlugin.getDefault().getJavaElementLabelProvider().getImageLabel((Object)method, method.getFlags() | 2);
            recorder.recordProposal(image, 10, displayText, methodNameToUse, null);
        }
        catch (JavaModelException javaModelException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String searchForTextHover(Object selectedNode, int offset, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IXMLReferenceToJavaMethod toJavaMethod = (IXMLReferenceToJavaMethod)referenceTo;
        StringBuilder result = new StringBuilder();
        try {
            String[] classNames = this.getClassNames(selectedNode, file, referenceTo);
            if (classNames == null) return null;
            if (classNames.length == 0) {
                return null;
            }
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result.toString();
                }
                String className = stringArray[n2];
                IType type = JdtUtils.getJavaType(file.getProject(), className);
                if (type == null) {
                    return null;
                }
                IJavaMethodRequestor filter = toJavaMethod.getRequestor(selectedNode, file);
                if (filter == null) {
                    return null;
                }
                try {
                    this.createTextInfo(selectedNode, mathingString, result, type, filter);
                }
                catch (JavaModelException e) {
                    Trace.trace((byte)3, "Error while getting methods for class=" + className, e);
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private void createTextInfo(Object selectedNode, String matching, StringBuilder result, IType type, IJavaMethodRequestor requestor) throws JavaModelException {
        if (type == null) {
            return;
        }
        IMethod method = null;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            String info;
            method = methods[i];
            IStatus status = requestor.matchTotally(selectedNode, matching, method);
            if (status != null && status.isOK() && (info = new ProposalInfo((IMember)method).getInfo(EditorUtils.getProgressMonitor())) != null) {
                if (result.length() > 0) {
                    result.append("<br/></br/>");
                }
                result.append(info);
            }
            ++i;
        }
        this.createTextInfo(selectedNode, matching, result, JdtUtils.getSuperType(type), requestor);
    }
}

