/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.io.File;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.DirectoryDialog;

public class AbsoluteFolderPathBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Folder.Absolute";
    @Text(value="absolute fol&der path")
    private static LocalizableText label;

    static {
        LocalizableText.init(AbsoluteFolderPathBrowseActionHandler.class);
    }

    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.setLabel(label.text());
        this.addImage((ImageData)ImageData.readFromClassLoader(AbsoluteFolderPathBrowseActionHandler.class, (String)"Folder.png").required());
    }

    @Override
    protected String browse(Presentation context) {
        Value<?> property = this.property();
        DirectoryDialog dialog = new DirectoryDialog(((FormComponentPresentation)context).shell());
        dialog.setText(property.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        dialog.setMessage(this.createBrowseDialogMessage(property.definition().getLabel(true, CapitalizationType.NO_CAPS, false)));
        Value<?> value = property;
        Path path = (Path)value.content();
        if (path != null) {
            File f = new File(path.toOSString());
            while (f != null && !f.exists()) {
                f = f.getParentFile();
            }
            if (f != null) {
                dialog.setFilterPath(f.getAbsolutePath());
            }
        }
        return dialog.open();
    }
}

