/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.gradle.core.workspace.NewLiferayWorkspaceOpMethods;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class WorkspaceNameValidationService
extends ValidationService {
    private static final String PROJECT_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!event.property().definition().equals(NewLiferayWorkspaceOp.PROP_WORKSPACE_NAME)) {
                    WorkspaceNameValidationService.this.refresh();
                }
            }
        };
        this.op().attach((Listener)this.listener, "*");
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            if (LiferayWorkspaceUtil.hasLiferayWorkspace()) {
                retval = Status.createErrorStatus((String)LiferayWorkspaceUtil.hasLiferayWorkspaceMsg);
                return retval;
            }
        }
        catch (CoreException e) {
            retval = StatusBridge.create((IStatus)e.getStatus());
            return retval;
        }
        NewLiferayWorkspaceOp op = this.op();
        String currentWorkspaceName = (String)op.getWorkspaceName().content();
        if (CoreUtil.isNullOrEmpty((String)currentWorkspaceName)) {
            retval = Status.createErrorStatus((String)"Liferay Workspace name could not be null");
            return retval;
        }
        IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentWorkspaceName, 4);
        if (!nameStatus.isOK()) {
            retval = StatusBridge.create((IStatus)nameStatus);
            return retval;
        }
        if (!this.isValidProjectName(currentWorkspaceName)) {
            retval = Status.createErrorStatus((String)"The name is invalid for a project");
            return retval;
        }
        if (this.isExistingFolder(op)) {
            retval = Status.createErrorStatus((String)("There is already a folder at the location \"" + ((Path)op.getLocation().content()).toString() + "\""));
            return retval;
        }
        if (this.isInvalidProjectName(op)) {
            retval = Status.createErrorStatus((String)"A project with that name already exists.");
            return retval;
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.op().detach((Listener)this.listener, "*");
    }

    private boolean isInvalidProjectName(NewLiferayWorkspaceOp op) {
        String workspaceName = (String)op.getWorkspaceName().content();
        return CoreUtil.getProject((String)workspaceName).exists();
    }

    private boolean isExistingFolder(NewLiferayWorkspaceOp op) {
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (useDefaultLocation) {
            Path newLocationBase = null;
            newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
            if (newLocationBase != null) {
                NewLiferayWorkspaceOpMethods.updateLocation(op, newLocationBase);
            }
            if (((Path)op.getLocation().content()).toFile().exists()) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidProjectName(String currentProjectName) {
        return currentProjectName.matches(PROJECT_NAME_REGEX);
    }

    private NewLiferayWorkspaceOp op() {
        return (NewLiferayWorkspaceOp)this.context(NewLiferayWorkspaceOp.class);
    }
}

