/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class PluginsSDKProjectRuntimeValidator
implements IFacetedProjectValidator {
    public static final String LOCATION_TARGETED_RUNTIMES = "Targeted Runtimes";
    public static final String ID_PRIMARY_RUNTIME_NOT_SET = "primary-runtime-not-set";
    public static final String ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME = "primary-runtime-not-liferay-runtime";
    public static final String ID_PLUGINS_SDK_NOT_SET = "plugins-sdk-not-set";
    public static final String MSG_PRIMARY_RUNTIME_NOT_SET = Msgs.primaryRuntimeNotSet;
    public static final String MSG_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME = Msgs.primaryRuntimeNotLiferayRuntime;
    public static final String LOCATION_TARGETED_SDK = "Targeted SDK";

    public void validate(IFacetedProject fproj) throws CoreException {
        IProject proj = fproj.getProject();
        if (ProjectUtil.isLiferayFacetedProject(proj)) {
            this.clearMarkers(proj);
            if (SDKUtil.isSDKProject((IProject)fproj.getProject())) {
                IJavaProject javaProject = JavaCore.create((IProject)proj);
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.sdk.container")) {
                        return;
                    }
                    ++n2;
                }
                if (fproj.getPrimaryRuntime() == null) {
                    this.setMarker(proj, "com.liferay.ide.project.core.LiferayProjectMarker", 2, MSG_PRIMARY_RUNTIME_NOT_SET, LOCATION_TARGETED_RUNTIMES, ID_PRIMARY_RUNTIME_NOT_SET);
                } else if (!ServerUtil.isLiferayRuntime((BridgedRuntime)((BridgedRuntime)fproj.getPrimaryRuntime()))) {
                    this.setMarker(proj, "com.liferay.ide.project.core.LiferayProjectMarker", 2, MSG_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME, LOCATION_TARGETED_RUNTIMES, ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME);
                }
            } else if (!ProjectUtil.isMavenProject(proj)) {
                this.setMarker(proj, "com.liferay.ide.project.core.LiferayProjectMarker", 2, Msgs.pluginSDKNotSet, LOCATION_TARGETED_SDK, ID_PLUGINS_SDK_NOT_SET);
            }
        }
    }

    private void clearMarkers(IProject proj) {
        try {
            if (proj.isOpen()) {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = proj.findMarkers("com.liferay.ide.project.core.LiferayProjectMarker", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String[] stringArray = this.getMarkerSourceIds();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        if (marker.getAttribute("sourceId").equals(id)) {
                            marker.delete();
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            ProjectCore.logError(e);
        }
    }

    private String[] getMarkerSourceIds() {
        return new String[]{ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME, ID_PRIMARY_RUNTIME_NOT_SET, ID_PLUGINS_SDK_NOT_SET};
    }

    private void setMarker(IProject proj, String markerType, int markerSeverity, String markerMsg, String markerLocation, String markerSourceId) throws CoreException {
        IMarker marker = proj.createMarker(markerType);
        marker.setAttribute("severity", markerSeverity);
        marker.setAttribute("message", (Object)markerMsg);
        marker.setAttribute("location", (Object)markerLocation);
        marker.setAttribute("sourceId", (Object)markerSourceId);
    }

    private static class Msgs
    extends NLS {
        public static String primaryRuntimeNotSet;
        public static String primaryRuntimeNotLiferayRuntime;
        public static String pluginSDKNotSet;

        static {
            Msgs.initializeMessages((String)PluginsSDKProjectRuntimeValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

