/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.AbstractPortletFramework;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.LiferayDescriptorHelperReader;
import com.liferay.ide.project.core.PluginPackageResourceListener;
import com.liferay.ide.project.core.SDKBuildPropertiesResourceListener;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ProjectCore
extends Plugin {
    public static final String LIFERAY_PROJECT_MARKER_TYPE = "com.liferay.ide.project.core.LiferayProjectMarker";
    private static ProjectCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.project.core";
    private static PluginPackageResourceListener pluginPackageResourceListener;
    private static SDKBuildPropertiesResourceListener sdkBuildPropertiesResourceListener;
    private static IPortletFramework[] portletFrameworks;
    public static final String PREF_CREATE_NEW_PORLET = "create-new-portlet";
    public static final String PREF_DEFAULT_PLUGIN_PROJECT_BUILD_TYPE_OPTION = "project-plugin_default-build-type-option";
    public static final String PREF_DEFAULT_MODULE_PROJECT_BUILD_TYPE_OPTION = "project-module-default-build-type-option";
    public static final String PREF_DEFAULT_PLUGIN_PROJECT_MAVEN_GROUPID = "default-plugin-project-maven-groupid";
    public static final String PREF_DEFAULT_MODULE_PROJECT_MAVEN_GROUPID = "default-module-project-maven-groupid";
    public static final String PREF_INCLUDE_SAMPLE_CODE = "include-sample-code";
    public static final String USE_PROJECT_SETTINGS = "use-project-settings";

    public static IStatus createErrorStatus(Exception e) {
        return ProjectCore.createErrorStatus(PLUGIN_ID, e);
    }

    public static IStatus createErrorStatus(String msg) {
        return ProjectCore.createErrorStatus(PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg) {
        return new Status(4, pluginId, msg);
    }

    public static IStatus createErrorStatus(String pluginId, String msg, Throwable e) {
        return new Status(4, pluginId, msg, e);
    }

    public static IStatus createErrorStatus(String pluginId, Throwable t) {
        return new Status(4, pluginId, t.getMessage(), t);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, message);
    }

    public static IStatus createWarningStatus(String message, String id) {
        return new Status(2, id, message);
    }

    public static IStatus createWarningStatus(String message, String id, Exception e) {
        return new Status(2, id, message, (Throwable)e);
    }

    public static ProjectCore getDefault() {
        return plugin;
    }

    private static LiferayDescriptorHelper[] getDescriptorHelpers(IProject project, Class<? extends IDescriptorOperation> type) {
        LiferayDescriptorHelper[] allHelpers;
        ArrayList<LiferayDescriptorHelper> retval = new ArrayList<LiferayDescriptorHelper>();
        if ((project = CoreUtil.getLiferayProject((IResource)project)) == null || !project.exists()) {
            return null;
        }
        LiferayDescriptorHelper[] liferayDescriptorHelperArray = allHelpers = LiferayDescriptorHelperReader.getInstance().getAllHelpers();
        int n = allHelpers.length;
        int n2 = 0;
        while (n2 < n) {
            LiferayDescriptorHelper helper = liferayDescriptorHelperArray[n2];
            helper.setProject(project);
            IFile descriptorFile = helper.getDescriptorFile();
            if (descriptorFile != null && descriptorFile.exists() && helper.getDescriptorOperation(type) != null) {
                retval.add(helper);
            }
            ++n2;
        }
        return retval.toArray(new LiferayDescriptorHelper[0]);
    }

    public static IPortletFramework getPortletFramework(String name) {
        IPortletFramework[] iPortletFrameworkArray = ProjectCore.getPortletFrameworks();
        int n = iPortletFrameworkArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPortletFramework framework = iPortletFrameworkArray[n2];
            if (framework.getShortName().equals(name)) {
                return framework;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized IPortletFramework[] getPortletFrameworks() {
        Object[] elements;
        if (portletFrameworks == null && !CoreUtil.isNullOrEmpty((Object[])(elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.project.core.portletFrameworks")))) {
            ArrayList<AbstractPortletFramework> frameworks = new ArrayList<AbstractPortletFramework>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String id = element.getAttribute("id");
                String shortName = element.getAttribute("shortName");
                String displayName = element.getAttribute("displayName");
                String description = element.getAttribute("description");
                String requiredSDKVersion = element.getAttribute("requiredSDKVersion");
                boolean isDefault = Boolean.parseBoolean(element.getAttribute("default"));
                boolean isAdvanced = Boolean.parseBoolean(element.getAttribute("advanced"));
                boolean isRequiresAdvanced = Boolean.parseBoolean(element.getAttribute("requiresAdvanced"));
                URL helpUrl = null;
                try {
                    helpUrl = new URL(element.getAttribute("helpUrl"));
                }
                catch (Exception exception) {}
                try {
                    AbstractPortletFramework framework = (AbstractPortletFramework)element.createExecutableExtension("class");
                    framework.setId(id);
                    framework.setShortName(shortName);
                    framework.setDisplayName(displayName);
                    framework.setDescription(description);
                    framework.setRequiredSDKVersion(requiredSDKVersion);
                    framework.setHelpUrl(helpUrl);
                    framework.setDefault(isDefault);
                    framework.setAdvanced(isAdvanced);
                    framework.setRequiresAdvanced(isRequiresAdvanced);
                    framework.setBundleId(element.getContributor().getName());
                    frameworks.add(framework);
                }
                catch (Exception e) {
                    ProjectCore.logError("Could not create portlet framework.", e);
                }
                ++n2;
            }
            portletFrameworks = frameworks.toArray(new IPortletFramework[0]);
            Arrays.sort(portletFrameworks, 0, portletFrameworks.length, new Comparator<IPortletFramework>(){

                @Override
                public int compare(IPortletFramework o1, IPortletFramework o2) {
                    if (o1.isDefault() && !o2.isDefault()) {
                        return -1;
                    }
                    if (!o1.isDefault() && o2.isDefault()) {
                        return 1;
                    }
                    return o1.getShortName().compareTo(o2.getShortName());
                }
            });
        }
        return portletFrameworks;
    }

    public static void logError(IStatus status) {
        ProjectCore.getDefault().getLog().log(status);
    }

    public static void logError(String msg) {
        ProjectCore.logError(ProjectCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        ProjectCore.getDefault().getLog().log(ProjectCore.createErrorStatus(PLUGIN_ID, msg, e));
    }

    public static void logError(String msg, Throwable t) {
        ProjectCore.getDefault().getLog().log(ProjectCore.createErrorStatus(PLUGIN_ID, msg, t));
    }

    public static void logError(Throwable t) {
        ProjectCore.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static IStatus operate(IProject project, Class<? extends IDescriptorOperation> type, Object ... params) {
        LiferayDescriptorHelper[] helpers;
        IStatus status = Status.OK_STATUS;
        LiferayDescriptorHelper[] liferayDescriptorHelperArray = helpers = ProjectCore.getDescriptorHelpers(project, type);
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            LiferayDescriptorHelper helper = liferayDescriptorHelperArray[n2];
            status = helper.getDescriptorOperation(type).execute(params);
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return status;
    }

    public ProjectCore() {
        pluginPackageResourceListener = new PluginPackageResourceListener();
        sdkBuildPropertiesResourceListener = new SDKBuildPropertiesResourceListener();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)sdkBuildPropertiesResourceListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (pluginPackageResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener);
        }
        if (sdkBuildPropertiesResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)sdkBuildPropertiesResourceListener);
        }
    }
}

