/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.MarkerUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.util.ClasspathUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SDKBuildPropertiesResourceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final String MARKER_ID_SDK_PROPERTIES_INVALID = "sdk-properties-invalid";
    private static final String ID_WORKSPACE_SDK_INVALID = "workspace-sdk-invalid";
    private static final Pattern PATTERN_BUILD_PROPERTIES = Pattern.compile("build.[\\w|\\W.]*properties");

    private boolean checkMultipleSDK(IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        boolean hasMultipleSDK = false;
        boolean findSDK = false;
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject existProject = iProjectArray[n2];
            if (SDKUtil.isValidSDKLocation((String)existProject.getLocation().toPortableString())) {
                IMarker[] problemMarkers = MarkerUtil.findMarkers((IResource)existProject, (String)"org.eclipse.core.resources.problemmarker", (String)ID_WORKSPACE_SDK_INVALID);
                if (!findSDK) {
                    if (problemMarkers != null && problemMarkers.length > 0) {
                        MarkerUtil.clearMarkers((IResource)existProject, (String)"org.eclipse.core.resources.problemmarker", (String)ID_WORKSPACE_SDK_INVALID);
                    }
                    findSDK = true;
                } else {
                    if (problemMarkers == null || problemMarkers.length < 1) {
                        MarkerUtil.setMarker((IResource)existProject, (String)"org.eclipse.core.resources.problemmarker", (int)2, (String)"Workspace has more than one SDK", (String)existProject.getFullPath().toPortableString(), (String)ID_WORKSPACE_SDK_INVALID);
                    }
                    hasMultipleSDK = true;
                }
                existProject.refreshLocal(2, monitor);
            }
            ++n2;
        }
        return hasMultipleSDK;
    }

    protected void processPropertiesFileChanged(IFile deltaFile) throws CoreException {
        block13: {
            IProject deltaProject = deltaFile.getProject();
            SDK sdk = SDKUtil.createSDKFromLocation((IPath)deltaProject.getLocation());
            if (sdk == null) break block13;
            IMarker[] problemMarkers = MarkerUtil.findMarkers((IResource)deltaFile, (String)"org.eclipse.core.resources.problemmarker", (String)MARKER_ID_SDK_PROPERTIES_INVALID);
            IStatus sdkStatus = sdk.validate(true);
            if (sdkStatus.isOK()) {
                if (problemMarkers != null && problemMarkers.length > 0) {
                    MarkerUtil.clearMarkers((IResource)deltaFile, (String)"org.eclipse.core.resources.problemmarker", (String)MARKER_ID_SDK_PROPERTIES_INVALID);
                }
                IProject[] iProjectArray = CoreUtil.getAllProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final IProject project = iProjectArray[n2];
                    if (SDKUtil.isSDKProject((IProject)project) && sdk.getLocation().isPrefixOf(project.getLocation())) {
                        WorkspaceJob job = new WorkspaceJob("Updating dependencies " + project.getName()){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                ClasspathUtil.updateRequestContainer(project);
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    ++n2;
                }
            } else {
                int n;
                IStatus[] statuses = sdkStatus.getChildren();
                IMarker[] iMarkerArray = problemMarkers;
                int n3 = problemMarkers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    boolean canDelete = true;
                    String message = (String)marker.getAttribute("message");
                    IStatus[] iStatusArray = statuses;
                    int n5 = statuses.length;
                    n = 0;
                    while (n < n5) {
                        IStatus status = iStatusArray[n];
                        if (status.getMessage().equals(message)) {
                            canDelete = false;
                            break;
                        }
                        ++n;
                    }
                    if (canDelete) {
                        marker.delete();
                    }
                    ++n4;
                }
                iMarkerArray = statuses;
                n3 = statuses.length;
                n4 = 0;
                while (n4 < n3) {
                    IMarker status = iMarkerArray[n4];
                    boolean canAdd = true;
                    IMarker[] iMarkerArray2 = problemMarkers;
                    n = problemMarkers.length;
                    int n6 = 0;
                    while (n6 < n) {
                        IMarker marker = iMarkerArray2[n6];
                        String message = (String)marker.getAttribute("message");
                        if (status.getMessage().equals(message)) {
                            canAdd = false;
                            break;
                        }
                        ++n6;
                    }
                    if (canAdd) {
                        MarkerUtil.setMarker((IResource)deltaFile, (String)"org.eclipse.core.resources.problemmarker", (int)2, (String)status.getMessage(), (String)deltaFile.getFullPath().toPortableString(), (String)MARKER_ID_SDK_PROPERTIES_INVALID);
                    }
                    ++n4;
                }
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta child = iResourceDeltaArray[n2];
                    IResource resource = child.getResource();
                    if (resource != null) {
                        IProject[] sdkProjects;
                        IProject[] iProjectArray = sdkProjects = SDKUtil.getWorkspaceSDKs();
                        int n3 = sdkProjects.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IProject sdkProject = iProjectArray[n4];
                            IPath sdkProjectLocation = sdkProject.getLocation();
                            if (sdkProjectLocation != null) {
                                IResourceDelta[] sdkChangedFiles;
                                IResourceDelta[] iResourceDeltaArray2 = sdkChangedFiles = child.getAffectedChildren(7);
                                int n5 = sdkChangedFiles.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    String deltaLastSegment;
                                    Matcher propertiesMatcher;
                                    IResourceDelta sdkDelta = iResourceDeltaArray2[n6];
                                    IResource sdkDeltaResource = sdkDelta.getResource();
                                    if (sdkDeltaResource != null && sdkDeltaResource.getLocation() != null && sdkProjectLocation.isPrefixOf(sdkDeltaResource.getLocation()) && (propertiesMatcher = PATTERN_BUILD_PROPERTIES.matcher(deltaLastSegment = sdkDelta.getFullPath().lastSegment())).matches()) {
                                        sdkDelta.accept((IResourceDeltaVisitor)this);
                                        break;
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable e) {
            ProjectCore.logError("build.properties resource listener failed.", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                final IFile deltaFile = (IFile)delta.getResource();
                WorkspaceJob job = new WorkspaceJob("Processing SDK build properties file"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            SDK sdk;
                            IPath deltaLocation;
                            boolean hasMultipleSDK = SDKBuildPropertiesResourceListener.this.checkMultipleSDK(monitor);
                            if (!hasMultipleSDK && (deltaLocation = deltaFile.getLocation()) != null && (sdk = SDKUtil.getWorkspaceSDK()).getLocation().isPrefixOf(deltaLocation)) {
                                SDKBuildPropertiesResourceListener.this.processPropertiesFileChanged(deltaFile);
                            }
                        }
                        catch (CoreException e) {
                            ProjectCore.logError(e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                return false;
            }
        }
        return false;
    }
}

