/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PluginTypeValidationService
extends ValidationService {
    protected void initValidationService() {
        super.initValidationService();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PluginTypeValidationService.this.refresh();
            }
        };
        this.op().getProjectProvider().attach((Listener)listener);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            SDK sdk = SDKUtil.getWorkspaceSDK();
            NewLiferayPluginProjectOp op = this.op();
            if (sdk != null) {
                if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.web) && !NewLiferayPluginProjectOpMethods.supportsExtOrWebTypePlugin(op, "web")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating new web type plugins.  Please configure version 7.0 or greater.");
                } else if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.ext) && !NewLiferayPluginProjectOpMethods.supportsExtOrWebTypePlugin(op, "ext")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating ext type plugins.  Please configure version 6.2 or less.");
                }
            } else if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.ext) && !NewLiferayPluginProjectOpMethods.supportsExtOrWebTypePlugin(op, "ext")) {
                retval = Status.createErrorStatus((String)"The Maven does not support creating ext type plugins.");
            }
        }
        catch (CoreException coreException) {}
        return retval;
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

