/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;
import org.osgi.framework.Version;

public class SDKLocationValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SDKLocationValidationService.this.refresh();
            }
        };
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_PROVIDER).attach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_NAME).attach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PORTLET_FRAMEWORK).attach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PLUGIN_TYPE).attach(this.listener);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        if (((NewLiferayProjectProvider)this.op().getProjectProvider().content()).getShortName().equals("ant")) {
            Version sdkVersion;
            IPortletFramework portletFramework;
            Version requiredVersion;
            int countPossibleWorkspaceSDKProjects = SDKUtil.countPossibleWorkspaceSDKProjects();
            if (countPossibleWorkspaceSDKProjects > 1) {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This workspace has more than one SDK. "));
            }
            Path sdkLocation = (Path)this.op().getSdkLocation().content(true);
            if (sdkLocation == null || sdkLocation.isEmpty()) {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This sdk location is empty "));
            }
            SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation));
            if (sdk != null) {
                IStatus status = sdk.validate(true);
                if (!status.isOK()) {
                    return StatusBridge.create((IStatus)status);
                }
            } else {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This sdk location is not correct"));
            }
            Path projectLocation = (Path)this.op().getLocation().content();
            String projectName = (String)this.op().getProjectName().content();
            IPath projectPath = PathBridge.create((Path)projectLocation);
            if (projectPath != null && projectPath.toFile().exists()) {
                return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("Project(" + projectName + ") is existed in sdk folder, please set new project name"));
            }
            if (((PluginType)((Object)this.op().getPluginType().content())).equals((Object)PluginType.web)) {
                if (!NewLiferayPluginProjectOpMethods.supportsExtOrWebTypePlugin(this.op(), "web")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating new web type plugins.  Please configure version 7.0 or greater.");
                }
            } else if (((PluginType)((Object)this.op().getPluginType().content())).equals((Object)PluginType.ext)) {
                if (!NewLiferayPluginProjectOpMethods.supportsExtOrWebTypePlugin(this.op(), "ext")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating ext type plugins.  Please configure version 6.2 or less.");
                }
            } else if (((PluginType)((Object)this.op().getPluginType().content())).equals((Object)PluginType.portlet) && CoreUtil.compareVersions((Version)(requiredVersion = new Version((portletFramework = (IPortletFramework)this.op().getPortletFramework().content()).getRequiredSDKVersion())), (Version)(sdkVersion = new Version(sdk.getVersion()))) > 0) {
                retval = Status.createErrorStatus((String)("Selected portlet framework requires SDK version at least " + requiredVersion));
            }
        }
        return retval;
    }

    public void dispose() {
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_NAME).detach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PORTLET_FRAMEWORK).detach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PLUGIN_TYPE).detach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_PROVIDER).detach(this.listener);
        super.dispose();
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

