/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BaseModuleOp;
import com.liferay.ide.project.core.modules.BaseOpMethods;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class ModuleProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ModuleProjectNameListener.updateLocation(this.op(event));
    }

    protected BaseModuleOp op(PropertyContentEvent event) {
        return (BaseModuleOp)event.property().element().nearest(BaseModuleOp.class);
    }

    public static void updateLocation(BaseModuleOp op) {
        String currentProjectName = (String)op.getProjectName().content(true);
        if (currentProjectName == null || CoreUtil.isNullOrEmpty((String)currentProjectName.trim())) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (useDefaultLocation) {
            Path newLocationBase = null;
            boolean hasLiferayWorkspace = false;
            try {
                hasLiferayWorkspace = LiferayWorkspaceUtil.hasLiferayWorkspace();
            }
            catch (Exception exception) {
                ProjectCore.logError("Failed to check LiferayWorkspace project. ");
            }
            if (hasLiferayWorkspace) {
                IProject liferayWorkspaceProject = LiferayWorkspaceUtil.getLiferayWorkspaceProject();
                if (liferayWorkspaceProject != null && liferayWorkspaceProject.exists()) {
                    String liferayWorkspaceProjectModulesDir = LiferayWorkspaceUtil.getLiferayWorkspaceProjectModulesDir(liferayWorkspaceProject);
                    if (liferayWorkspaceProjectModulesDir != null) {
                        IPath modulesPath = liferayWorkspaceProject.getLocation().append(liferayWorkspaceProjectModulesDir);
                        newLocationBase = modulesPath != null && modulesPath.toFile().exists() ? PathBridge.create((IPath)modulesPath) : PathBridge.create((IPath)liferayWorkspaceProject.getLocation().append("modules"));
                    }
                } else {
                    newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
                }
            } else {
                newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
            }
            if (newLocationBase != null) {
                BaseOpMethods.updateLocation(op, newLocationBase);
            }
        }
    }
}

