/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class VersionedDTDRootElementController
extends StandardRootElementController {
    private final Pattern publicIdPattern;
    private final String publicIdTemplate;
    private StandardRootElementController.RootElementInfo rootElementInfo;
    private final Pattern systemIdPattern;
    private final String systemIdTemplate;
    private final String xmlBindingPath;

    public VersionedDTDRootElementController(String xmlBindingPath, String publicIdTemplate, String systemIdTemplate, Pattern publicIdPattern, Pattern systemIdPattern) {
        this.xmlBindingPath = xmlBindingPath;
        this.publicIdTemplate = publicIdTemplate;
        this.systemIdTemplate = systemIdTemplate;
        this.publicIdPattern = publicIdPattern;
        this.systemIdPattern = systemIdPattern;
    }

    private boolean checkDocType() {
        try {
            String systemIdVersion;
            Matcher systemIdMatcher;
            String version;
            Matcher publicIdMatcher;
            DocumentType docType;
            Document document = this.getDocument();
            if (document != null && (docType = document.getDoctype()) != null && (publicIdMatcher = this.publicIdPattern.matcher(docType.getPublicId())).matches() && (version = publicIdMatcher.group(1)) != null && (systemIdMatcher = this.systemIdPattern.matcher(docType.getSystemId())).matches() && (systemIdVersion = systemIdMatcher.group(1)) != null && systemIdVersion.replaceAll("_", "").equals(version.replaceAll("\\.", ""))) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean checkRootElement() {
        boolean checkRoot = super.checkRootElement();
        if (checkRoot) {
            return this.checkDocType();
        }
        return false;
    }

    public void createRootElement() {
        super.createRootElement();
        if (!this.checkDocType()) {
            IProject project = (IProject)this.resource().adapt(IProject.class);
            String defaultVersion = LiferayDescriptorHelper.getDescriptorVersion(project);
            DocumentType existingDocType = this.getDocument().getDoctype();
            if (existingDocType != null) {
                this.getDocument().removeChild(existingDocType);
            }
            String publicId = MessageFormat.format(this.publicIdTemplate, defaultVersion);
            String systemId = MessageFormat.format(this.systemIdTemplate, defaultVersion.replaceAll("\\.", "_"));
            DocumentType newDocType = this.getDocument().getImplementation().createDocumentType(this.xmlBindingPath, publicId, systemId);
            if (newDocType != null) {
                this.getDocument().insertBefore(newDocType, this.getDocument().getDocumentElement());
            }
        }
    }

    private Document getDocument() {
        RootXmlResource rootXmlResource = (RootXmlResource)this.resource().root();
        return rootXmlResource.getDomDocument();
    }

    protected StandardRootElementController.RootElementInfo getRootElementInfo() {
        if (this.rootElementInfo == null) {
            this.rootElementInfo = new StandardRootElementController.RootElementInfo(null, null, this.xmlBindingPath, null);
        }
        return this.rootElementInfo;
    }
}

