/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.ui.workspace;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ProjectExplorerLayoutUtil {
    private static String NEST_PARAMETER = "org.eclipse.ui.navigator.resources.nested.enabled";

    public static void setNestedEnabled() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand("org.eclipse.ui.navigator.resources.nested.changeProjectPresentation");
            IHandler hanlder = command.getHandler();
            IViewPart projectExplorer = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (hanlder != null && projectExplorer != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(NEST_PARAMETER, "true");
                EvaluationContext applicationContext = new EvaluationContext(null, new Object());
                applicationContext.addVariable("activePart", (Object)projectExplorer);
                ExecutionEvent event = new ExecutionEvent(command, map, null, (Object)applicationContext);
                ProjectExplorerLayoutUtil.execute(event);
            }
        }
        catch (ExecutionException executionException) {}
    }

    private static void execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        String nestedProjectsContentProviderExtensionId = "org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider";
        String hideTopLevelProjectIfNested = "org.eclipse.ui.navigator.resources.nested.HideTopLevelProjectIfNested";
        String hideFolderWhenProjectIsShownAsNested = "org.eclipse.ui.navigator.resources.nested.HideFolderWhenProjectIsShownAsNested";
        if (part instanceof CommonNavigator) {
            CommonNavigator navigator = (CommonNavigator)part;
            boolean previousNest = navigator.getNavigatorContentService().getActivationService().isNavigatorExtensionActive(nestedProjectsContentProviderExtensionId);
            String newNestParam = event.getParameter(NEST_PARAMETER);
            boolean newNest = false;
            if (newNestParam != null) {
                newNest = Boolean.parseBoolean(newNestParam);
            }
            if (newNest != previousNest) {
                ISelection initialSelection = navigator.getCommonViewer().getSelection();
                INavigatorFilterService filterService = navigator.getNavigatorContentService().getFilterService();
                HashSet<String> filters = new HashSet<String>();
                ICommonFilterDescriptor[] iCommonFilterDescriptorArray = filterService.getVisibleFilterDescriptors();
                int n = iCommonFilterDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommonFilterDescriptor desc = iCommonFilterDescriptorArray[n2];
                    if (filterService.isActive(desc.getId())) {
                        filters.add(desc.getId());
                    }
                    ++n2;
                }
                if (newNest) {
                    navigator.getNavigatorContentService().getActivationService().activateExtensions(new String[]{nestedProjectsContentProviderExtensionId}, false);
                    filters.add(hideTopLevelProjectIfNested);
                    filters.add(hideFolderWhenProjectIsShownAsNested);
                } else {
                    navigator.getNavigatorContentService().getActivationService().deactivateExtensions(new String[]{nestedProjectsContentProviderExtensionId}, false);
                    filters.remove(hideTopLevelProjectIfNested);
                    filters.remove(hideFolderWhenProjectIsShownAsNested);
                }
                filterService.activateFilterIdsAndUpdateViewer(filters.toArray(new String[filters.size()]));
                navigator.getNavigatorContentService().getActivationService().persistExtensionActivations();
                navigator.getCommonViewer().refresh();
                navigator.getCommonViewer().setSelection(initialSelection);
            }
            HandlerUtil.updateRadioState((Command)event.getCommand(), (String)Boolean.toString(newNest));
        }
    }
}

