/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.search.ui.internal.Trace;
import org.w3c.dom.Node;

public class DOMUtils {
    public static IDOMNode getSelectedNode(ITextEditor textEditor) {
        IStructuredSelection structuredSelection;
        Object selectedElement;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        ITextSelection textSelection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            IDOMNode selectedNode = (IDOMNode)selectedElement;
            return DOMUtils.getSelectedAttrIfCan(textSelection, selectedNode);
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFile file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            if (model == null) {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
            }
            if (model == null) {
                return null;
            }
            IDOMNode selectedNode = org.eclipse.wst.xml.search.core.util.DOMUtils.getNodeByOffset((IStructuredModel)model, (int)textSelection.getOffset());
            IDOMNode iDOMNode = DOMUtils.getSelectedAttrIfCan(textSelection, selectedNode);
            return iDOMNode;
        }
        catch (Throwable e) {
            Trace.trace((byte)2, e.getMessage(), e);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private static IDOMNode getSelectedAttrIfCan(ITextSelection textSelection, IDOMNode selectedNode) {
        IDOMAttr attr = org.eclipse.wst.xml.search.core.util.DOMUtils.getAttrByOffset((Node)selectedNode, (int)textSelection.getOffset());
        if (attr != null) {
            return attr;
        }
        return selectedNode;
    }

    public static String toString(IDOMNode node) {
        switch (node.getNodeType()) {
            case 2: {
                return DOMUtils.toString((IDOMAttr)node);
            }
            case 3: {
                return DOMUtils.toString((IDOMText)node);
            }
            case 1: {
                return DOMUtils.toString((IDOMElement)node);
            }
        }
        return node.toString();
    }

    public static String toString(IDOMAttr attr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('@');
        buffer.append(attr.getNodeName());
        buffer.append('(');
        buffer.append(attr.getValue());
        buffer.append(") ");
        DOMUtils.toRegionString((IDOMNode)attr, buffer);
        IDOMElement element = (IDOMElement)attr.getOwnerElement();
        if (element != null) {
            buffer.append(" - Owner element: ");
            DOMUtils.toString(element, buffer);
        }
        return buffer.toString();
    }

    public static String toString(IDOMText text) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(text.getNodeName());
        buffer.append('(');
        buffer.append(text.getData());
        buffer.append(") ");
        DOMUtils.toRegionString((IDOMNode)text, buffer);
        Node parentNode = text.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1) {
            buffer.append(" - Owner element: ");
            DOMUtils.toString((IDOMElement)parentNode, buffer);
        }
        return buffer.toString();
    }

    public static void toString(IDOMElement element, StringBuilder buffer) {
        String tagName = element.getTagName();
        if (element.hasStartTag()) {
            buffer.append(tagName);
        }
        if (element.isEmptyTag()) {
            buffer.append('/');
        }
        if (element.hasEndTag()) {
            buffer.append('/');
            buffer.append(tagName);
        }
        if (buffer.length() == 0) {
            buffer.append(tagName);
        }
        DOMUtils.toRegionString((IDOMNode)element, buffer);
    }

    public static String toString(IDOMElement element) {
        StringBuilder buffer = new StringBuilder();
        DOMUtils.toString(element, buffer);
        return buffer.toString();
    }

    private static void toRegionString(IDOMNode element, StringBuilder buffer) {
        IStructuredDocumentRegion endStructuredDocumentRegion;
        IStructuredDocumentRegion startStructuredDocumentRegion = element.getStartStructuredDocumentRegion();
        if (startStructuredDocumentRegion != null) {
            buffer.append('@');
            buffer.append(startStructuredDocumentRegion.toString());
        }
        if ((endStructuredDocumentRegion = element.getEndStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(endStructuredDocumentRegion.toString());
        }
    }
}

