/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class LiferayLanguagePropertiesValidator {
    public static final String ID_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFAULT = "language-properties-encoding-not-defalut";
    public static final String LIFERAY_LANGUAGE_PROPERTIES_MARKER_TYPE = "com.liferay.ide.core.LiferayLanguagePropertiesMarker";
    private static WeakHashMap<IFile, WeakReference<LiferayLanguagePropertiesValidator>> filesAndValidators = new WeakHashMap();
    public static final String LOCATION_ENCODING = "Properties/Resource/Text file encoding";
    public static final String MESSAGE_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFALUT = Msgs.languagePropertiesEncodingNotDefault;
    private IFile file;
    private Set<IMarker> markers = new HashSet<IMarker>();

    public static void clearAbandonedMarkers() {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = CoreUtil.getWorkspaceRoot().findMarkers(LIFERAY_LANGUAGE_PROPERTIES_MARKER_TYPE, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (!marker.getResource().exists()) {
                    marker.delete();
                } else if (marker.getResource().getType() == 1) {
                    LiferayLanguagePropertiesValidator.getValidator((IFile)marker.getResource()).validateEncoding();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUnusedValidatorsAndMarkers(IProject project) throws CoreException {
        WeakHashMap<IFile, WeakReference<LiferayLanguagePropertiesValidator>> weakHashMap = filesAndValidators;
        synchronized (weakHashMap) {
            IMarker[] markers;
            Set<IFile> files = filesAndValidators.keySet();
            Iterator<IFile> iterator = files.iterator();
            while (iterator.hasNext()) {
                IFile file = iterator.next();
                if (PropertiesUtil.isLanguagePropertiesFile(file)) continue;
                iterator.remove();
            }
            IMarker[] iMarkerArray = markers = project.getWorkspace().getRoot().findMarkers(LIFERAY_LANGUAGE_PROPERTIES_MARKER_TYPE, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (!marker.getResource().exists()) {
                    marker.delete();
                } else if (marker.getResource().getType() == 1 && !files.contains((IFile)marker.getResource())) {
                    marker.delete();
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiferayLanguagePropertiesValidator getValidator(IFile file) {
        WeakHashMap<IFile, WeakReference<LiferayLanguagePropertiesValidator>> weakHashMap = filesAndValidators;
        synchronized (weakHashMap) {
            try {
                if (filesAndValidators.get(file).get() != null) {
                    return (LiferayLanguagePropertiesValidator)filesAndValidators.get(file).get();
                }
                throw new NullPointerException();
            }
            catch (NullPointerException nullPointerException) {
                LiferayLanguagePropertiesValidator validator = new LiferayLanguagePropertiesValidator(file);
                filesAndValidators.put(file, new WeakReference<LiferayLanguagePropertiesValidator>(validator));
                return validator;
            }
        }
    }

    private LiferayLanguagePropertiesValidator(IFile file) {
        this.file = file;
        try {
            IMarker[] iMarkerArray = file.findMarkers(LIFERAY_LANGUAGE_PROPERTIES_MARKER_TYPE, false, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (ID_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFAULT.equals(marker.getAttribute("sourceId"))) {
                    this.markers.add(marker);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LiferayCore.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMarker(String markerSourceId) {
        try {
            Set<IMarker> set = this.markers;
            synchronized (set) {
                for (IMarker marker : this.markers) {
                    if (marker == null || !marker.exists() || !markerSourceId.equals(marker.getAttribute("sourceId"))) continue;
                    this.markers.remove(marker);
                    marker.delete();
                }
            }
        }
        catch (CoreException e) {
            LiferayCore.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarker(String markerType, String markerSourceId, int markerSeverity, String location, String markerMsg) throws CoreException, InterruptedException {
        Set<IMarker> set = this.markers;
        synchronized (set) {
            IMarker marker2;
            for (IMarker marker2 : this.markers) {
                if (marker2 == null || !marker2.exists() || !markerSourceId.equals(marker2.getAttribute("sourceId"))) continue;
                return;
            }
            marker2 = this.file.createMarker(markerType);
            marker2.setAttribute("severity", markerSeverity);
            marker2.setAttribute("message", (Object)markerMsg);
            marker2.setAttribute("sourceId", (Object)markerSourceId);
            marker2.setAttribute("location", (Object)location);
            this.markers.add(marker2);
        }
    }

    public void validateEncoding() {
        block5: {
            if (PropertiesUtil.isLanguagePropertiesFile(this.file)) {
                try {
                    if (!"UTF-8".equals(this.file.getCharset())) {
                        this.setMarker(LIFERAY_LANGUAGE_PROPERTIES_MARKER_TYPE, ID_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFAULT, 1, LOCATION_ENCODING, NLS.bind((String)MESSAGE_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFALUT, (Object[])new Object[]{this.file.getName()}));
                        break block5;
                    }
                    this.clearMarker(ID_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFAULT);
                }
                catch (Exception e) {
                    LiferayCore.logError(e);
                }
            } else {
                this.clearMarker(ID_LANGUAGE_PROPERTIES_ENCODING_NOT_DEFAULT);
            }
        }
    }

    private static class Msgs
    extends NLS {
        public static String languagePropertiesEncodingNotDefault;

        static {
            Msgs.initializeMessages((String)LiferayLanguagePropertiesValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

