/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.alloy.core.jsp;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.javascript.JsDataTypes;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.NodeHelper;
import org.eclipse.wst.jsdt.web.core.javascript.Util;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class AlloyJsTranslator
extends JsTranslator {
    private static final String EVENT_HANDLER_PRE = "(function(){";
    private static final int EVENT_HANDLER_PRE_LENGTH = "(function(){".length();
    private static final String EVENT_HANDLER_POST = "})();";
    private static final int EVENT_HANDLER_POST_LENGTH = "})();".length();
    public static final String[] ALLOYATTREVENTS = new String[]{"onActiveStateChange", "onBlurMethod", "onBoundingBoxChange", "onChange", "onChangeMethod", "onClassNamesChange", "onClick", "onContentBoxChange", "onContentUpdate", "onCssClassChange", "onDefaultStateChange", "onDepthChange", "onDestroy", "onDestroyedChange", "onDisabledChange", "onFocusedChange", "onFocusMethod", "onHandlerChange", "onHeightChange", "onHideClassChange", "onHoverStateChange", "onIconChange", "onIconNodeChange", "onIdChange", "onIndexChange", "onInit", "onInitializedChange", "onLabelChange", "onLabelNodeChange", "onlyActions", "onParentChange", "onRender", "onRenderChange", "onRenderedChange", "onRootChange", "onSelectedChange", "onSrcNodeChange", "onStringsChange", "onSubmit", "onTabIndexChange", "onTitleChange", "onTypeChange", "onUseARIAChange", "onVisibleChange", "onWidthChange"};

    public AlloyJsTranslator(IStructuredDocument doc, String baseLocation, boolean listen) {
        super(doc, baseLocation, listen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            if (this.getCurrentNode() != null) {
                NodeHelper nh = new NodeHelper(this.getCurrentNode());
                while (this.getCurrentNode() != null && !this.isCanceled()) {
                    nh.setDocumentRegion(this.getCurrentNode());
                    if (this.getCurrentNode().getType() == "XML_TAG_NAME") {
                        if ((!nh.isEndTag() || nh.isSelfClosingTag()) && (nh.nameEquals("script") || nh.nameEquals("aui:script"))) {
                            if (NodeHelper.isInArray((String[])JsDataTypes.JSVALIDDATATYPES, (String)nh.getAttributeValue("type")) || NodeHelper.isInArray((String[])JsDataTypes.JSVALIDDATATYPES, (String)nh.getAttributeValue("language")) || nh.getAttributeValue("type") == null && nh.getAttributeValue("language") == null && this.isGlobalJs()) {
                                if (nh.containsAttribute(new String[]{"src"})) {
                                    this.translateScriptImportNode(this.getCurrentNode());
                                }
                                if (this.getCurrentNode().getNext() != null) {
                                    this.translateJSNode(this.getCurrentNode().getNext());
                                }
                            }
                        } else if (nh.containsAttribute(JsDataTypes.HTMLATREVENTS) || nh.containsAttribute(ALLOYATTREVENTS)) {
                            this.translateInlineJSNode(this.getCurrentNode());
                        } else if (nh.nameEquals("META") && nh.attrEquals("http-equiv", "Content-Script-Type") && nh.containsAttribute(new String[]{"content"})) {
                            this.setIsGlobalJs(NodeHelper.isInArray((String[])JsDataTypes.JSVALIDDATATYPES, (String)nh.getAttributeValue("content")));
                        }
                    }
                    if (this.getCurrentNode() == null) continue;
                    this.advanceNextNode();
                }
                if (this.getCompUnitBuffer() != null) {
                    this.getCompUnitBuffer().setContents(this.fScriptText.toString());
                }
            }
            this.finishedTranslation();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void translateInlineJSNode(IStructuredDocumentRegion container) {
        ITextRegionList t = container.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext() && !this.isCanceled()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            r.getStart();
            r.getTextEnd();
            String tagAttrname = container.getText(r);
            if (!NodeHelper.isInArray((String[])JsDataTypes.HTMLATREVENTS, (String)tagAttrname) && !NodeHelper.isInArray((String[])ALLOYATTREVENTS, (String)tagAttrname)) continue;
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int valStartOffset = container.getStartOffset(r);
            String rawText = container.getText(r);
            if (rawText == null || rawText.length() == 0) continue;
            switch (rawText.charAt(0)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(1);
                    ++valStartOffset;
                }
            }
            if (rawText == null || rawText.length() == 0) continue;
            switch (rawText.charAt(rawText.length() - 1)) {
                case '\"': 
                case '\'': {
                    rawText = rawText.substring(0, rawText.length() - 1);
                }
            }
            new Position(valStartOffset, rawText.length());
            char[] spaces = Util.getPad((int)Math.max(0, valStartOffset - this.scriptOffset - EVENT_HANDLER_PRE_LENGTH));
            int i = 0;
            while (i < spaces.length) {
                try {
                    char c = this.fStructuredDocument.getChar(this.scriptOffset + i);
                    if (c == '\n' || c == '\r' || c == '\t') {
                        spaces[i] = c;
                    }
                }
                catch (BadLocationException e) {
                    Logger.logException((Throwable)e);
                }
                ++i;
            }
            this.fScriptText.append(spaces);
            this.fScriptText.append(EVENT_HANDLER_PRE);
            this.appendAndTrack(rawText, valStartOffset);
            this.fScriptText.append(";");
            if (r.getLength() > rawText.length()) {
                this.fScriptText.append(EVENT_HANDLER_POST);
                spaces = Util.getPad((int)Math.max(0, r.getLength() - rawText.length() - EVENT_HANDLER_POST_LENGTH));
                this.fScriptText.append(spaces);
            }
            this.scriptOffset = container.getEndOffset(r);
        }
    }
}

