/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.ui.wizard;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.ui.HookUI;
import com.liferay.ide.hook.ui.wizard.NewServiceWrapperClassDialog;
import com.liferay.ide.hook.ui.wizard.PortalServiceSearchScope;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.wizard.StringArrayTableWizardSection;
import com.liferay.ide.ui.dialog.FilteredTypesSelectionDialogEx;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServicesTableWizardSection
extends StringArrayTableWizardSection {
    protected String[] buttonLabels = new String[]{Msgs.select, Msgs.selectNew};
    protected IProject project;
    protected File servicesPropertiesFile = null;

    public ServicesTableWizardSection(Composite parent, String componentLabel, String dialogTitle, String addButtonLabel, String editButtonLabel, String removeButtonLabel, String[] columnTitles, String[] fieldLabels, Image labelProviderImage, IDataModel model, String propertyName) {
        super(parent, componentLabel, dialogTitle, addButtonLabel, editButtonLabel, removeButtonLabel, columnTitles, fieldLabels, labelProviderImage, model, propertyName);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void handleAddButtonSelected() {
        AddServiceDialog dialog = new AddServiceDialog(this.getShell(), this.dialogTitle, this.fieldLabels, this.buttonLabels);
        if (dialog.open() == 0) {
            String[] stringArray = dialog.getStringArray();
            this.addStringArray(stringArray);
        }
    }

    protected void handleEditButtonSelected() {
        ISelection s = this.viewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        Object selectedObj = selection.getFirstElement();
        String[] valuesForText = (String[])selectedObj;
        EditServiceDialog dialog = new EditServiceDialog(this.getShell(), this.dialogTitle, this.fieldLabels, valuesForText);
        dialog.open();
        String[] stringArray = dialog.getStringArray();
        this.editStringArray(valuesForText, stringArray);
    }

    public class AddServiceDialog
    extends StringArrayTableWizardSection.AddStringArrayDialog {
        protected String[] buttonLabels;
        protected CLabel errorMessageLabel;

        public AddServiceDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] buttonLabels) {
            super((StringArrayTableWizardSection)ServicesTableWizardSection.this, shell, windowTitle, labelsForTextField);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.buttonLabels = buttonLabels;
            this.setWidthHint(450);
        }

        protected Control createContents(Composite parent) {
            Composite composite = (Composite)super.createContents(parent);
            this.getButton(0).setEnabled(false);
            return composite;
        }

        public Control createDialogArea(Composite parent) {
            super.createDialogArea(parent);
            this.errorMessageLabel = new CLabel(parent, 0x2000000);
            this.errorMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.errorMessageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.errorMessageLabel.setVisible(false);
            return parent;
        }

        protected Text createField(Composite parent, final int index) {
            Label label = new Label(parent, 16384);
            label.setText(this.labelsForTextField[index]);
            label.setLayoutData((Object)new GridData(32));
            final Text text = new Text(parent, 2052);
            GridData data = new GridData(768);
            text.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(parent, 0);
            String[] buttonLbls = this.buttonLabels[index].split(",");
            GridLayout gl = new GridLayout(buttonLbls.length, true);
            gl.marginWidth = 0;
            gl.horizontalSpacing = 1;
            buttonComposite.setLayout((Layout)gl);
            String[] stringArray = buttonLbls;
            int n = buttonLbls.length;
            int n2 = 0;
            while (n2 < n) {
                final String lbl = stringArray[n2];
                Button button = new Button(buttonComposite, 8);
                button.setText(lbl);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddServiceDialog.this.handleArrayDialogButtonSelected(index, lbl, text);
                    }
                });
                ++n2;
            }
            return text;
        }

        protected void handleArrayDialogButtonSelected(int index, String label, Text text) {
            if (index == 0) {
                this.handleSelectServiceButton(text);
            } else if (index == 1 && Msgs.select.equals(label)) {
                this.handleSelectImplClassButton(text);
            } else if (index == 1 && Msgs.newLabel.equals(label)) {
                this.handleNewImplClassButton(text);
            }
        }

        protected void handleNewImplClassButton(Text text) {
            NewServiceWrapperClassDialog dialog;
            if (CoreUtil.isNullOrEmpty((String)this.texts[0].getText())) {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)Msgs.addService, (String)Msgs.specifyServiceType);
                return;
            }
            String serviceType = this.texts[0].getText();
            String wrapperType = "";
            if (serviceType.endsWith("Service")) {
                wrapperType = String.valueOf(serviceType) + "Wrapper";
            }
            if ((dialog = new NewServiceWrapperClassDialog(this.getShell(), ServicesTableWizardSection.this.model, serviceType, wrapperType)).open() == 0) {
                String qualifiedClassname = dialog.getQualifiedClassname();
                text.setText(qualifiedClassname);
            }
        }

        protected void handleSelectImplClassButton(Text text) {
            if (CoreUtil.isNullOrEmpty((String)this.texts[0].getText())) {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)Msgs.addService, (String)Msgs.specifyServiceType);
                return;
            }
            IPackageFragmentRoot packRoot = (IPackageFragmentRoot)ServicesTableWizardSection.this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
            if (packRoot == null) {
                return;
            }
            IJavaSearchScope scope = null;
            try {
                String serviceType = this.texts[0].getText();
                if (serviceType.endsWith("Service")) {
                    String wrapperType = String.valueOf(serviceType) + "Wrapper";
                    scope = BasicSearchEngine.createHierarchyScope((IType)packRoot.getJavaProject().findType(wrapperType));
                }
            }
            catch (JavaModelException e) {
                HookUI.logError((Exception)((Object)e));
                return;
            }
            FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, null, scope, 5);
            dialog.setTitle(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE);
            dialog.setMessage(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String classFullPath = "";
                if (type != null) {
                    classFullPath = type.getFullyQualifiedName();
                }
                text.setText(classFullPath);
            }
        }

        protected void handleSelectServiceButton(Text text) {
            PortalServiceSearchScope scope = new PortalServiceSearchScope();
            scope.setResourcePattern(new String[]{".*Service.class$"});
            IProject project = ProjectUtil.getProject((IDataModel)ServicesTableWizardSection.this.model);
            ILiferayProject liferayProject = LiferayCore.create((Object)project);
            IPath serviceJarPath = liferayProject.getLibraryPath("portal-service");
            scope.setEnclosingJarPaths(new IPath[]{serviceJarPath});
            FilteredTypesSelectionDialogEx dialog = new FilteredTypesSelectionDialogEx(this.getShell(), false, null, (IJavaSearchScope)scope, 6);
            dialog.setTitle(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_TITLE);
            dialog.setMessage(J2EEUIMessages.SUPERCLASS_SELECTION_DIALOG_DESC);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String classFullPath = "";
                if (type != null) {
                    classFullPath = type.getFullyQualifiedName();
                }
                text.setText(classFullPath);
            }
        }

        public void modifyText(ModifyEvent e) {
            boolean serviceTypeValid = false;
            boolean implClassValid = false;
            if (this.texts[0].getText().trim().length() > 0) {
                int serviceTypeStatus = JavaConventions.validateJavaTypeName((String)this.texts[0].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = serviceTypeValid = serviceTypeStatus != 4;
            }
            if (this.texts[1].getText().trim().length() > 0) {
                int implClasseStatus = JavaConventions.validateJavaTypeName((String)this.texts[1].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = implClassValid = implClasseStatus != 4;
            }
            if (!(serviceTypeValid ^ implClassValid)) {
                this.errorMessageLabel.setText("Invalid service name and class name");
            } else if (!serviceTypeValid) {
                this.errorMessageLabel.setText("Invalid service type name");
            } else if (!implClassValid) {
                this.errorMessageLabel.setText("Invalid class name");
            }
            this.errorMessageLabel.setVisible(!serviceTypeValid || !implClassValid);
            this.getButton(0).setEnabled(serviceTypeValid && implClassValid);
        }
    }

    public class EditServiceDialog
    extends StringArrayTableWizardSection.EditStringArrayDialog {
        protected CLabel errorMessageLabel;

        public EditServiceDialog(Shell shell, String windowTitle, String[] labelsForTextField, String[] valuesForTextField) {
            super((StringArrayTableWizardSection)ServicesTableWizardSection.this, shell, windowTitle, labelsForTextField, valuesForTextField);
        }

        public Control createDialogArea(Composite parent) {
            super.createDialogArea(parent);
            this.errorMessageLabel = new CLabel(parent, 0x2000000);
            this.errorMessageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.errorMessageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.errorMessageLabel.setVisible(false);
            return parent;
        }

        public void modifyText(ModifyEvent e) {
            boolean serviceTypeValid = false;
            boolean implClassValid = false;
            if (this.texts[0].getText().trim().length() > 0) {
                int serviceTypeStatus = JavaConventions.validateJavaTypeName((String)this.texts[0].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = serviceTypeValid = serviceTypeStatus != 4;
            }
            if (this.texts[1].getText().trim().length() > 0) {
                int implClasseStatus = JavaConventions.validateJavaTypeName((String)this.texts[1].getText().trim(), (String)"1.5", (String)"1.5").getSeverity();
                boolean bl = implClassValid = implClasseStatus != 4;
            }
            if (!(serviceTypeValid ^ implClassValid)) {
                this.errorMessageLabel.setText("Invalid service name and class name");
            } else if (!serviceTypeValid) {
                this.errorMessageLabel.setText("Invalid service type name");
            } else if (!implClassValid) {
                this.errorMessageLabel.setText("Invalid class name");
            }
            this.errorMessageLabel.setVisible(!serviceTypeValid || !implClassValid);
            this.getButton(0).setEnabled(serviceTypeValid && implClassValid);
        }
    }

    private static class Msgs
    extends NLS {
        public static String addService;
        public static String newLabel;
        public static String select;
        public static String selectNew;
        public static String specifyServiceType;

        static {
            Msgs.initializeMessages((String)ServicesTableWizardSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

