/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.properties.IPropertiesCollector;
import org.eclipse.wst.xml.search.core.properties.IPropertiesRequestor;
import org.eclipse.wst.xml.search.core.properties.IPropertiesSearchEngine;

public class PropertiesSearchEngine
implements IPropertiesSearchEngine {
    private static final IPropertiesSearchEngine INSTANCE = new PropertiesSearchEngine();

    public static IPropertiesSearchEngine getDefault() {
        return INSTANCE;
    }

    @Override
    public IStatus search(Object selectedNode, IResource[] containers, IPropertiesRequestor requestor, IPropertiesCollector collector, String matching, boolean fullMatch, IProgressMonitor monitor) {
        int i = 0;
        while (i < containers.length) {
            IResource resource = containers[i];
            this.internalSearch(selectedNode, resource, containers[i], requestor, collector, matching, fullMatch, monitor);
            ++i;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus search(Object selectedNode, IResource container, IPropertiesRequestor requestor, IPropertiesCollector collector, String matching, boolean fullMatch, IProgressMonitor monitor) {
        this.internalSearch(selectedNode, container, container, requestor, collector, matching, fullMatch, monitor);
        return Status.OK_STATUS;
    }

    private void internalSearch(Object selectedNode, IResource rootContainer, IResource container, IPropertiesRequestor requestor, IPropertiesCollector collector, String matching, boolean fullMatch, IProgressMonitor monitor) {
        if (!requestor.accept(container, rootContainer)) {
            return;
        }
        int resourceType = container.getType();
        switch (resourceType) {
            case 1: {
                IFile file = (IFile)container;
                this.processFile(file, collector, matching, fullMatch);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                try {
                    this.internalSearch(selectedNode, rootContainer, ((IContainer)container).members(), requestor, collector, matching, fullMatch, monitor);
                    break;
                }
                catch (CoreException e) {
                    Trace.trace((byte)3, e.getMessage(), e);
                }
            }
        }
    }

    private IStatus internalSearch(Object selectedNode, IResource rootContainer, IResource[] containers, IPropertiesRequestor requestor, IPropertiesCollector collector, String matching, boolean fullMatch, IProgressMonitor monitor) {
        int i = 0;
        while (i < containers.length) {
            this.internalSearch(selectedNode, rootContainer, containers[i], requestor, collector, matching, fullMatch, monitor);
            ++i;
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(IFile file, IPropertiesCollector collector, String matching, boolean fullMatch) {
        InputStream contents = null;
        try {
            try {
                Properties properties = new Properties();
                contents = file.getContents();
                properties.load(contents);
                if (fullMatch) {
                    if (!properties.containsKey(matching)) return;
                    String value = properties.getProperty(matching);
                    collector.add((IStorage)file, matching, value);
                    return;
                } else {
                    String matchingUpperCased = matching.toUpperCase();
                    String key = null;
                    String value = null;
                    Set<Map.Entry<Object, Object>> entries = properties.entrySet();
                    for (Map.Entry<Object, Object> entry : entries) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (!key.toUpperCase().startsWith(matchingUpperCased)) continue;
                        collector.add((IStorage)file, key, value);
                    }
                }
                return;
            }
            catch (CoreException e) {
                e.printStackTrace();
                if (contents == null) return;
                try {
                    contents.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (contents == null) return;
                try {
                    contents.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

