/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wst.xml.search.core.xpath.matcher.AbstractXPathNodeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathAttributeMatcher;
import org.eclipse.wst.xml.search.core.xpath.matcher.XPathMatcher;
import org.w3c.dom.Node;

public class XPathElementMatcher
extends AbstractXPathNodeMatcher {
    public static final String ANY_ELEMENT_NAME = "*";
    private List<XPathAttributeMatcher> attributes = null;
    private final String prefix;
    private final String localName;
    private final boolean anyElementName;

    public XPathElementMatcher(String prefix, String localName, XPathMatcher matcher) {
        super(matcher);
        this.prefix = prefix;
        this.localName = localName;
        this.anyElementName = ANY_ELEMENT_NAME.equals(localName);
    }

    @Override
    public IXPathNodeMatcher.MatcherType getType() {
        return IXPathNodeMatcher.MatcherType.ELEMENT;
    }

    @Override
    public boolean match(Node testNode, Collection<String> wildcardValues) {
        if (!this.matchElement(testNode)) {
            return false;
        }
        return this.matchAttributes(testNode, wildcardValues);
    }

    private boolean matchElement(Node testNode) {
        String LocalName = testNode.getLocalName();
        if (LocalName == null) {
            LocalName = testNode.getNodeName();
        }
        return this.matchElement(LocalName);
    }

    private boolean matchElement(String localName) {
        if (this.anyElementName) {
            return true;
        }
        return this.localName.equals(localName);
    }

    private boolean matchAttributes(Node testNode, Collection<String> wildcardValues) {
        if (this.attributes == null) {
            return true;
        }
        for (XPathAttributeMatcher attribute : this.attributes) {
            if (attribute.match(testNode, wildcardValues)) continue;
            return false;
        }
        return true;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    @Override
    public boolean isAny() {
        return this.anyElementName;
    }

    public void add(XPathAttributeMatcher matcher) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<XPathAttributeMatcher>();
        }
        this.attributes.add(matcher);
    }
}

