/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.xml.search.ui.AbstractResourceBundleMarkerResolution;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddResourceKeyMarkerResolution
extends AbstractResourceBundleMarkerResolution {
    private IFile resourceBundle = null;

    public AddResourceKeyMarkerResolution(IMarker marker, IFile languageFile) {
        super(marker);
        this.resourceBundle = languageFile;
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append("Add missing key to ");
        sb.append(this.resourceBundle.getProjectRelativePath().toString());
        return sb.toString();
    }

    public Image getImage() {
        URL url = LiferayXMLSearchUI.getDefault().getBundle().getEntry("/icons/resource-bundle.png");
        return ImageDescriptor.createFromURL((URL)url).createImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void resolve(IMarker marker) {
        String languageKey;
        InputStream is;
        block19: {
            block18: {
                String message = marker.getAttribute("message", "");
                if (message == null || this.resourceBundle == null) {
                    return;
                }
                is = null;
                is = this.resourceBundle.getContents();
                languageKey = this.getResourceKey(marker);
                if (!CoreUtil.isNullOrEmpty((String)languageKey)) break block18;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            Properties properties = new Properties();
            properties.load(is);
            if (properties.get(languageKey) == null) break block19;
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                String resourceValue = this.getDefaultResourceValue(languageKey);
                String resourcePropertyLine = String.valueOf(languageKey) + "=" + resourceValue;
                String contents = CoreUtil.readStreamToString((InputStream)this.resourceBundle.getContents());
                StringBuffer contentSb = new StringBuffer();
                contentSb.append(contents);
                if (!contents.endsWith("\n")) {
                    contentSb.append("\n");
                }
                contentSb.append(resourcePropertyLine);
                this.resourceBundle.setContents((InputStream)new ByteArrayInputStream(contentSb.toString().trim().getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                this.openEditor(this.resourceBundle);
            }
            catch (Exception e) {
                LiferayXMLSearchUI.logError(e);
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

