/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.action.sdk;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.ui.action.AbstractObjectAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class SDKCommandAction
extends AbstractObjectAction {
    protected abstract String getSDKCommand();

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            IFile buildXmlFile = null;
            IProject project = null;
            Object elem = elems[0];
            if (elem instanceof IFile) {
                buildXmlFile = (IFile)elem;
                project = buildXmlFile.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
                buildXmlFile = project.getFile("build.xml");
            }
            if (buildXmlFile.exists()) {
                final IProject p = project;
                final IFile buildFile = buildXmlFile;
                new Job(String.valueOf(p.getName()) + " : " + this.getSDKCommand()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            SDK sdk = SDKUtil.getSDK((IProject)p);
                            ILiferayProject liferayProject = LiferayCore.create((Object)p);
                            if (liferayProject != null) {
                                sdk.runCommand(p, buildFile, SDKCommandAction.this.getSDKCommand(), null, monitor);
                                p.refreshLocal(2, monitor);
                            }
                        }
                        catch (Exception e) {
                            return ProjectUI.createErrorStatus("Error running SDK command " + SDKCommandAction.this.getSDKCommand(), e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }
}

