/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.ui.migration.AutoCorrectAction;
import com.liferay.ide.project.ui.migration.IgnoreAction;
import com.liferay.ide.project.ui.migration.MarkDoneAction;
import com.liferay.ide.project.ui.migration.MarkUndoneAction;
import com.liferay.ide.project.ui.migration.OpenAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class MigrationActionProvider
extends CommonActionProvider {
    private ICommonViewerSite viewerSite;
    private SelectionProviderAction _autoCorrectAction;
    private SelectionProviderAction _ignoreAction;
    private SelectionProviderAction _markDoneAction;
    private SelectionProviderAction _markUndoneAction;
    private SelectionProviderAction _openAction;

    private void addListeners(CommonViewer cv) {
        cv.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Object data = sel.getFirstElement();
                    if (!(data instanceof IFile)) {
                        return;
                    }
                    MigrationActionProvider.this._openAction.run();
                }
                catch (Exception exception) {}
            }
        });
    }

    public void fillContextMenu(IMenuManager menu) {
        Object selection = this.getFirstSelectedElement();
        if (selection instanceof Problem) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this._markDoneAction);
            menu.add((IAction)this._markUndoneAction);
            menu.add((IAction)this._ignoreAction);
            menu.add((IAction)this._autoCorrectAction);
            menu.add((IContributionItem)new Separator());
        } else if (selection instanceof FileProblems) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this._markDoneAction);
            menu.add((IAction)this._markUndoneAction);
            menu.add((IAction)this._ignoreAction);
            menu.add((IContributionItem)new Separator());
        }
    }

    private Object getFirstSelectedElement() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            return sSelection.getFirstElement();
        }
        return null;
    }

    public void init(ICommonActionExtensionSite site) {
        StructuredViewer v;
        super.init(site);
        this.viewerSite = site.getViewSite();
        if (this.viewerSite instanceof ICommonViewerWorkbenchSite && (v = site.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            this.addListeners(cv);
        }
    }

    public MigrationActionProvider makeActions(ISelectionProvider provider) {
        this._openAction = new OpenAction(provider);
        this._markDoneAction = new MarkDoneAction(provider);
        this._markUndoneAction = new MarkUndoneAction(provider);
        this._ignoreAction = new IgnoreAction(provider);
        this._autoCorrectAction = new AutoCorrectAction(provider);
        return this;
    }

    void registerSelectionProvider(ISelectionProvider provider) {
        provider.addSelectionChangedListener((ISelectionChangedListener)this._openAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this._markDoneAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this._markUndoneAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this._ignoreAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this._autoCorrectAction);
    }
}

