/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.LiferaySDKField;
import com.liferay.ide.project.ui.wizard.SDKProjectsImportWizardPage;
import com.liferay.ide.ui.util.SWTUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class BinaryProjectsImportWizardPage
extends SDKProjectsImportWizardPage
implements ISDKProjectsImportDataModelProperties {
    protected Text binariesLocation;

    public BinaryProjectsImportWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(Msgs.importLiferayBinaryPlugins);
        this.setDescription(Msgs.selectBinaryPlugins);
    }

    protected void createBinaryLocationField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Msgs.selectPluginsRootDirectoryLabel);
        label.setLayoutData((Object)new GridData(32));
        this.binariesLocation = SWTUtil.createSingleText((Composite)parent, (int)1);
        this.binariesLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BinaryProjectsImportWizardPage.this.binariesLocation.isFocusControl() && "" == BinaryProjectsImportWizardPage.this.binariesLocation.getText()) {
                    BinaryProjectsImportWizardPage.this.setMessage(null);
                }
            }
        });
        Button browse = SWTUtil.createButton((Composite)parent, (String)Msgs.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryProjectsImportWizardPage.this.doBrowse();
            }
        });
    }

    @Override
    protected void createPluginsSDKField(Composite parent) {
        this.createBinaryLocationField(parent);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryProjectsImportWizardPage.this.synchHelper.synchAllUIWithModel();
                BinaryProjectsImportWizardPage.this.validatePage(true);
                BinaryProjectsImportWizardPage.this.updateBinariesList();
            }
        };
        new LiferaySDKField(parent, this.getDataModel(), selectionAdapter, "ISDKProjectsImportDataModelProperties.LIFERAY_SDK_NAME", this.synchHelper, Msgs.selectSDKLabel);
    }

    @Override
    protected void createProjectsList(Composite workArea) {
        super.createProjectsList(workArea);
        this.labelProjectsList.setText(Msgs.binaryPluginsLabel);
    }

    @Override
    protected IBaseLabelProvider createProjectsListLabelProvider() {
        return new BinaryLabelProvider();
    }

    protected void doBrowse() {
        String dir;
        DirectoryDialog dd = new DirectoryDialog(this.getShell(), 4096);
        String filterPath = this.binariesLocation.getText();
        if (filterPath != null) {
            dd.setFilterPath(filterPath);
            dd.setText(NLS.bind((String)Msgs.selectRootDirectoryPath, (Object)filterPath));
        } else {
            dd.setText(Msgs.selectRootDirectory);
        }
        if (CoreUtil.isNullOrEmpty((String)this.binariesLocation.getText())) {
            dd.setFilterPath(this.binariesLocation.getText());
        }
        if (!CoreUtil.isNullOrEmpty((String)(dir = dd.open()))) {
            this.binariesLocation.setText(dir);
            this.updateProjectsList(dir);
        }
    }

    @Override
    protected void enter() {
    }

    @Override
    public Object[] getProjectRecords() {
        ArrayList<BinaryProjectRecord> binaryProjectRecords = new ArrayList<BinaryProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            BinaryProjectRecord binaryProjectRecord = (BinaryProjectRecord)this.selectedProjects[i];
            if (this.isProjectInWorkspace(binaryProjectRecord.getLiferayPluginName())) {
                binaryProjectRecord.setConflicts(true);
            }
            binaryProjectRecords.add(binaryProjectRecord);
            ++i;
        }
        return binaryProjectRecords.toArray(new BinaryProjectRecord[binaryProjectRecords.size()]);
    }

    @Override
    protected void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    @Override
    protected void handleDeselectAll(SelectionEvent e) {
        this.projectsList.setCheckedElements(new Object[0]);
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.validatePage(true);
        this.setPageComplete(false);
    }

    @Override
    protected void handleRefresh(SelectionEvent e) {
        this.lastModified = -1L;
        this.updateProjectsList(this.binariesLocation.getText());
        this.projectsList.setCheckedElements(new Object[0]);
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.validatePage(true);
        this.setPageComplete(false);
    }

    @Override
    protected void handleSelectAll(SelectionEvent e) {
        int i = 0;
        while (i < this.selectedProjects.length) {
            BinaryProjectRecord binaryProject = (BinaryProjectRecord)this.selectedProjects[i];
            if (binaryProject.isConflicts()) {
                this.projectsList.setChecked((Object)binaryProject, false);
            } else {
                this.projectsList.setChecked((Object)binaryProject, true);
            }
            ++i;
        }
        this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.projectsList.getCheckedElements());
        this.validatePage(true);
    }

    public void updateBinariesList() {
        String path = this.binariesLocation.getText();
        if (path != null) {
            this.updateProjectsList(path);
        }
    }

    @Override
    public void updateProjectsList(String path) {
        Object[] checkedBinaries;
        if (path == null || path.length() == 0) {
            this.setMessage("");
            this.selectedProjects = new BinaryProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements(this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        String sdkLocationPath = this.sdkLocation.getText();
        if (sdkLocationPath != null && sdkLocationPath.equals(path)) {
            path = String.valueOf(sdkLocationPath) + "/dist";
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            if (this.selectedProjects.length == 0) {
                this.setMessage("", 2);
            }
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("", 100);
                    BinaryProjectsImportWizardPage.this.selectedProjects = new BinaryProjectRecord[0];
                    ArrayList projectBinaries = new ArrayList();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        if (!ProjectImportUtil.collectBinariesFromDirectory(projectBinaries, (File)directory, (boolean)true, (IProgressMonitor)monitor)) {
                            return;
                        }
                        BinaryProjectsImportWizardPage.this.selectedProjects = new BinaryProjectRecord[projectBinaries.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask("");
                        for (File binaryFile : projectBinaries) {
                            BinaryProjectsImportWizardPage.this.selectedProjects[index++] = new BinaryProjectRecord(binaryFile);
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ProjectUI.logError(e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage("", 2);
        }
        if ((checkedBinaries = this.projectsList.getCheckedElements()) != null && checkedBinaries.length > 0) {
            this.selectedProjects = new BinaryProjectRecord[checkedBinaries.length];
            int i = 0;
            while (i < checkedBinaries.length) {
                this.selectedProjects[i] = (BinaryProjectRecord)checkedBinaries[i];
                ++i;
            }
            this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)this.selectedProjects);
        }
    }

    protected final class BinaryLabelProvider
    extends StyledCellLabelProvider {
        private static final String GREY_COLOR = "already_exist_element_color";
        private final ColorRegistry COLOR_REGISTRY = JFaceResources.getColorRegistry();
        private final StyledString.Styler GREYED_STYLER;

        public BinaryLabelProvider() {
            this.COLOR_REGISTRY.put(GREY_COLOR, new RGB(128, 128, 128));
            this.GREYED_STYLER = StyledString.createColorRegistryStyler((String)GREY_COLOR, null);
        }

        public Image getImage() {
            Image image = ProjectUI.getDefault().getImageRegistry().get("war.image");
            return image;
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            BinaryProjectRecord binaryProjectRecord = null;
            if (obj instanceof BinaryProjectRecord) {
                binaryProjectRecord = (BinaryProjectRecord)obj;
            }
            StyledString styledString = null;
            if (binaryProjectRecord.isConflicts()) {
                styledString = new StyledString(binaryProjectRecord.getBinaryName(), this.GREYED_STYLER);
                styledString.append(" (" + binaryProjectRecord.getFilePath() + ") ", this.GREYED_STYLER);
            } else {
                styledString = new StyledString(binaryProjectRecord.getBinaryName(), StyledString.createColorRegistryStyler((String)"CONTENT_ASSIST_FOREGROUND_COLOR", (String)"CONTENT_ASSIST_BACKGROUND_COLOR"));
                styledString.append(" (" + binaryProjectRecord.getFilePath() + ") ", this.GREYED_STYLER);
            }
            cell.setImage(this.getImage());
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            super.update(cell);
        }
    }

    private static class Msgs
    extends NLS {
        public static String binaryPluginsLabel;
        public static String browse;
        public static String importLiferayBinaryPlugins;
        public static String selectBinaryPlugins;
        public static String selectPluginsRootDirectoryLabel;
        public static String selectRootDirectory;
        public static String selectRootDirectoryPath;
        public static String selectSDKLabel;

        static {
            Msgs.initializeMessages((String)BinaryProjectsImportWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

