/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.ui.LiferayUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public abstract class LiferayDataModelWizardPage
extends DataModelWizardPage {
    public LiferayDataModelWizardPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] != null && !(selection[0] instanceof IProject) && !(selection[0] instanceof IFolder)) {
                    return Status.OK_STATUS;
                }
                return LiferayUIPlugin.createErrorStatus((String)Msgs.chooseValidProjectFile);
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(LiferayDataModelWizardPage.this.model.getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
                }
                if (element instanceof IFolder) {
                    return true;
                }
                return element instanceof IFile;
            }
        };
    }

    protected IJavaElement getInitialJavaElement(ISelection selection) {
        IResource resource;
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (jelem = this.getJavaElement(selectedElement = ((IStructuredSelection)selection).getFirstElement())) == null && (resource = this.getResource(selectedElement)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPart part = window.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = window.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return jelem;
    }

    protected IJavaElement getJavaElement(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IJavaElement) {
            return (IJavaElement)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IJavaElement)((IAdaptable)obj).getAdapter(IJavaElement.class);
        }
        return (IJavaElement)Platform.getAdapterManager().getAdapter(obj, IJavaElement.class);
    }

    protected IResource getResource(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        }
        return (IResource)Platform.getAdapterManager().getAdapter(obj, IResource.class);
    }

    protected IProject getSelectedProject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void handleFileBrowseButton(Text text, String title, String message) {
        IFolder defaultDocroot;
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        IWebProject lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)CoreUtil.getProject((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")));
        if (lrproject != null && (defaultDocroot = lrproject.getDefaultDocrootFolder()) != null) {
            dialog.setInput((Object)defaultDocroot);
            if (dialog.open() == 0) {
                Object element = dialog.getFirstResult();
                try {
                    if (element instanceof IFile) {
                        IFile file = (IFile)element;
                        IPath relativePath = file.getFullPath().makeRelativeTo(defaultDocroot.getFullPath());
                        text.setText("/" + relativePath.toPortableString());
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String initializeProjectList(Combo projectCombo, IDataModel dataModel) {
        IProject[] workspaceProjects = CoreUtil.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return null;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        projectCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (dataModel != null && (projectNameFromModel = dataModel.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = CoreUtil.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                projectCombo.setText(selectedProject.getName());
                this.validateProjectRequirements(selectedProject);
                dataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if ((projectCombo.getText() == null || projectCombo.getText().length() == 0) && names[0] != null) {
            projectCombo.setText(names[0]);
            this.validateProjectRequirements(CoreUtil.getProject((String)names[0]));
            dataModel.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)names[0]);
        }
        return names[0];
    }

    protected abstract boolean isProjectValid(IProject var1);

    protected void validateProjectRequirements(IProject project) {
    }

    private static class Msgs
    extends NLS {
        public static String chooseValidProjectFile;

        static {
            Msgs.initializeMessages((String)LiferayDataModelWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

