/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.ui.IvyUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.WorkingSetCustomPart;
import com.liferay.ide.ui.util.UIUtil;
import java.util.ArrayList;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;

public class NewLiferayPluginProjectWizard
extends SapphireWizard<NewLiferayPluginProjectOp>
implements IWorkbenchWizard,
INewWizard {
    private boolean firstErrorMessageRemoved = false;

    public NewLiferayPluginProjectWizard() {
        super((Element)NewLiferayPluginProjectWizard.createDefaultOp(), DefinitionLoader.sdef(NewLiferayPluginProjectWizard.class).wizard());
    }

    private void addToWorkingSets(IProject newProject) throws Exception {
        if (newProject != null) {
            for (FormComponentPart formPart : ((WizardPagePart)this.part().getPages().get(0)).children().all()) {
                WorkingSetCustomPart workingSetPart;
                Object[] workingSets;
                if (!(formPart instanceof WorkingSetCustomPart) || CoreUtil.isNullOrEmpty((Object[])(workingSets = (workingSetPart = (WorkingSetCustomPart)formPart).getWorkingSets()))) continue;
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newProject, (IWorkingSet[])workingSets);
            }
        }
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            int messageType = wizardPage.getMessageType();
            if (messageType == 3 && !CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage("Please enter a project name.", 0);
                this.firstErrorMessageRemoved = true;
            }
        }
        return wizardPages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void openLiferayPerspective(IProject newProject) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        DelegateConfigurationElement element = new DelegateConfigurationElement(null){

            public String getAttribute(String aName) {
                if (aName.equals("finalPerspective")) {
                    return "com.liferay.ide.eclipse.ui.perspective.liferay";
                }
                return super.getAttribute(aName);
            }
        };
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
    }

    protected void performPostFinish() {
        super.performPostFinish();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        NewLiferayPluginProjectOp op = (NewLiferayPluginProjectOp)((NewLiferayPluginProjectOp)this.element()).nearest(NewLiferayPluginProjectOp.class);
        ElementList projectNames = op.getProjectNames();
        for (ProjectName projectName : projectNames) {
            IProject newProject = CoreUtil.getProject((String)((String)projectName.getName().content()));
            if (newProject == null) continue;
            projects.add(newProject);
        }
        for (IProject project : projects) {
            try {
                this.addToWorkingSets(project);
            }
            catch (Exception ex) {
                ProjectUI.logError("Unable to add project to working set", ex);
            }
        }
        IProject finalProject = (IProject)projects.get(0);
        this.openLiferayPerspective(finalProject);
        this.showInAntView(finalProject);
        NewLiferayPluginProjectWizard.checkAndConfigureIvy(finalProject);
        boolean createNewPortlet = (Boolean)op.getCreateNewPortlet().content();
        if (createNewPortlet && PluginType.portlet.equals(op.getPluginType().content())) {
            IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content();
            String wizardId = null;
            if ("mvc".equals(portletFramework.getShortName())) {
                wizardId = "com.liferay.ide.portlet.ui.newPortletWizard";
            } else if ("jsf-2.x".equals(portletFramework.getShortName())) {
                wizardId = "com.liferay.ide.portlet.ui.newJSFPortletWizard";
            } else if ("vaadin".equals(portletFramework.getShortName())) {
                wizardId = "com.liferay.ide.portlet.vaadin.ui.newVaadinPortletWizard";
            }
            if (wizardId != null) {
                this.openNewPortletWizard(wizardId, finalProject);
            }
        }
    }

    public static void checkAndConfigureIvy(final IProject project) {
        if (project != null && project.getFile("ivy.xml").exists()) {
            new WorkspaceJob("Configuring project with Ivy dependencies"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        IvyUtil.configureIvyProject(project, monitor);
                    }
                    catch (CoreException e) {
                        return ProjectCore.createErrorStatus((String)"com.liferay.ide.project.core", (String)"Failed to configured ivy project.", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void openNewPortletWizard(String wizardId, final IProject project) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(wizardId);
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement element = iConfigurationElementArray[n2];
            if ("wizard".equals(element.getName())) {
                UIUtil.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            INewWizard wizard = (INewWizard)CoreUtility.createExtension((IConfigurationElement)element, (String)"class");
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
                            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                            dialog.create();
                            dialog.open();
                        }
                        catch (CoreException ex) {
                            ProjectCore.createErrorStatus((Exception)((Object)ex));
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private void showInAntView(final IProject project) {
        Display.getDefault().asyncExec(new Runnable(){

            private void addBuildInAntView() {
                IFile buildXmlFile;
                if (project != null && (buildXmlFile = project.getFile("build.xml")).exists()) {
                    String buildFileName = buildXmlFile.getFullPath().toString();
                    AntProjectNodeProxy antProject = new AntProjectNodeProxy(buildFileName);
                    project.getName();
                    IViewPart antView = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ant.ui.views.AntView");
                    if (antView instanceof AntView) {
                        ((AntView)antView).addProject((AntProjectNode)antProject);
                    }
                }
            }

            private void refreshProjectExplorer() {
                IViewPart view = null;
                try {
                    view = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                }
                catch (Exception exception) {}
                if (view == null) {
                    return;
                }
                CommonViewer viewer = (CommonViewer)view.getAdapter(CommonViewer.class);
                viewer.refresh(true);
            }

            @Override
            public void run() {
                this.refreshProjectExplorer();
                this.addBuildInAntView();
            }
        });
    }

    private static NewLiferayPluginProjectOp createDefaultOp() {
        return (NewLiferayPluginProjectOp)NewLiferayPluginProjectOp.TYPE.instantiate();
    }
}

