/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.model.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ResourceBundleValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    public Status compute() {
        Element modelElement = (Element)this.context(Element.class);
        if (!modelElement.disposed() && modelElement instanceof ResourceBundle) {
            String bundle = modelElement.property((ValueProperty)this.context(ValueProperty.class)).text(false);
            if (bundle != null && bundle.indexOf("/") != -1) {
                String correctBundle = bundle.replace("/", ".").replaceAll("\\.properties$", "");
                return Status.createErrorStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.invalidResourceBundleWithSlash), (Object[])new Object[]{"'" + bundle + "'", "'" + correctBundle + "'"}));
            }
            if (bundle != null && (bundle.startsWith(".") || bundle.contains(".."))) {
                return Status.createErrorStatus((String)Resources.bind((String)StringEscapeUtils.unescapeJava((String)Resources.invalidResourceBundleFileName), (Object[])new Object[]{"'" + bundle + "'"}));
            }
        }
        return Status.createOkStatus();
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!((ResourceBundle)ResourceBundleValidationService.this.context(ResourceBundle.class)).disposed()) {
                    ResourceBundleValidationService.this.refresh();
                }
            }
        };
        ((ResourceBundle)this.context(ResourceBundle.class)).attach((Listener)this.listener);
    }

    private static final class Resources
    extends NLS {
        public static String invalidResourceBundleWithSlash;
        public static String invalidResourceBundleFileName;

        static {
            Resources.initializeMessages((String)ResourceBundleValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

