/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.core.preferences;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Preferences;
import tern.eclipse.ide.core.IIDETernRepository;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.preferences.PreferencesSupport;
import tern.eclipse.ide.server.nodejs.core.INodejsInstall;
import tern.eclipse.ide.server.nodejs.core.TernNodejsCorePlugin;
import tern.utils.StringUtils;

public class TernNodejsCorePreferencesSupport {
    private static final String NODES_QUALIFIER = "tern.eclipse.ide.server.nodejs.core";
    private static final Preferences store = TernNodejsCorePlugin.getDefault().getPluginPreferences();
    private PreferencesSupport preferencesSupport = new PreferencesSupport("tern.eclipse.ide.server.nodejs.core", store);
    private static TernNodejsCorePreferencesSupport instance = null;

    private TernNodejsCorePreferencesSupport() {
    }

    public static TernNodejsCorePreferencesSupport getInstance() {
        if (instance == null) {
            instance = new TernNodejsCorePreferencesSupport();
        }
        return instance;
    }

    public INodejsInstall getNodejsInstall() {
        String id = this.preferencesSupport.getWorkspacePreferencesValue("nodeJSInstall");
        return TernNodejsCorePlugin.getNodejsInstallManager().findNodejsInstall(id);
    }

    public File getInstallPath() {
        INodejsInstall install = this.getNodejsInstall();
        if (install != null) {
            if (install.isNative()) {
                String path = this.preferencesSupport.getWorkspacePreferencesValue("nodeJSPath");
                if (!StringUtils.isEmpty((String)path)) {
                    return new File(path);
                }
            } else {
                return install.getPath();
            }
        }
        return new File("node");
    }

    public long getNodejsTimeout() {
        String timeout = this.preferencesSupport.getWorkspacePreferencesValue("nodeJSTimeout");
        try {
            return Long.parseLong(timeout);
        }
        catch (Throwable throwable) {
            return 200L;
        }
    }

    public int getNodejsTestNumber() {
        String timeout = this.preferencesSupport.getWorkspacePreferencesValue("nodeJSTestNumber");
        try {
            return Integer.parseInt(timeout);
        }
        catch (Throwable throwable) {
            return 50;
        }
    }

    public boolean isNodejsPersistent() {
        String persistent = this.preferencesSupport.getWorkspacePreferencesValue("nodeJSPersistent");
        try {
            return Boolean.parseBoolean(persistent);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isNodejsRemoteAccess() {
        String persistent = this.preferencesSupport.getWorkspacePreferencesValue("nodejsRemoteAccess");
        try {
            return Boolean.parseBoolean(persistent);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int getNodejsRemotePort() {
        String timeout = this.preferencesSupport.getWorkspacePreferencesValue("nodejsRemotePort");
        try {
            return Integer.parseInt(timeout);
        }
        catch (Throwable throwable) {
            return 1234;
        }
    }

    public String getDebugger() {
        return this.preferencesSupport.getWorkspacePreferencesValue("nodeJSDebugger");
    }

    public IFile getTernServerDebugFile() {
        String repositoryName = this.preferencesSupport.getWorkspacePreferencesValue("ternRepository");
        if (repositoryName != null) {
            try {
                IIDETernRepository repository = TernCorePlugin.getTernRepositoryManager().getRepository(repositoryName);
                return repository != null ? repository.getTernServerFile() : null;
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

