/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;

public class CustomJspPossibleValuesService
extends PossibleValuesService {
    final FileFilter jspfilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".jsp") || pathname.getName().endsWith(".jspf");
        }
    };
    private Path portalDir;
    private File[] possibleValues;

    protected void compute(Set<String> values) {
        ILiferayPortal portal;
        IProject project;
        ILiferayProject liferayProject;
        if (this.possibleValues == null && (liferayProject = LiferayCore.create((Object)(project = this.project()))) != null && (portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null) {
            this.portalDir = new Path(portal.getAppServerPortalDir().toPortableString());
            if (this.portalDir != null) {
                File portalDirFile = this.portalDir.toFile();
                File htmlDirFile = new File(portalDirFile, "html");
                LinkedList<File> fileValues = new LinkedList<File>();
                if (htmlDirFile.exists()) {
                    this.findJSPFiles(new File[]{htmlDirFile}, fileValues);
                } else {
                    File[] files = portalDirFile.listFiles(this.jspfilter);
                    this.findJSPFiles(files, fileValues);
                }
                this.possibleValues = fileValues.toArray(new File[0]);
            }
        }
        if (this.possibleValues != null) {
            File[] fileArray = this.possibleValues;
            int n = this.possibleValues.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                values.add(new Path(file.getAbsolutePath()).makeRelativeTo(this.portalDir).toPortableString());
                ++n2;
            }
        }
    }

    private void findJSPFiles(File[] files, List<File> fileValues) {
        if (!CoreUtil.isNullOrEmpty((Object[])files)) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.findJSPFiles(file.listFiles(this.jspfilter), fileValues);
                } else {
                    fileValues.add(file);
                }
                ++n2;
            }
        }
    }

    public Status problem(Value<?> value) {
        return Status.createOkStatus();
    }

    protected IProject project() {
        return ((IFile)((Element)this.context(Element.class)).root().adapt(IFile.class)).getProject();
    }
}

