/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.util;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.hook.core.dd.HookDescriptorHelper;
import com.liferay.ide.hook.core.model.CustomJspDir;
import com.liferay.ide.hook.core.model.Hook;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class HookUtil {
    public static boolean configureJSPSyntaxValidationExclude(IProject project, IFolder customFolder, boolean configureRule) {
        boolean retval = false;
        try {
            Validator validator = ValManager.getDefault().getValidator("org.eclipse.jst.jsp.core.JSPBatchValidator", project);
            ValidatorMutable validatorTable = new ValidatorMutable(validator);
            FilterGroup excludeGroup = null;
            FilterGroup[] filterGroupArray = validatorTable.getGroups();
            int n = filterGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (group.isExclude()) {
                    excludeGroup = group;
                    break;
                }
                ++n2;
            }
            String customJSPFolderPattern = customFolder.getFullPath().makeRelativeTo(customFolder.getProject().getFullPath()).toPortableString();
            FilterRule folderRule = FilterRule.createFile((String)customJSPFolderPattern, (boolean)true, (int)2);
            if (excludeGroup == null) {
                if (configureRule) {
                    excludeGroup = FilterGroup.create((boolean)true, (FilterRule[])new FilterRule[]{folderRule});
                    validatorTable.add(excludeGroup);
                    retval = true;
                }
            } else {
                boolean hasCustomJSPFolderRule = false;
                FilterRule[] filterRuleArray = excludeGroup.getRules();
                int n3 = filterRuleArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    FilterRule rule = filterRuleArray[n4];
                    if (customJSPFolderPattern.equals(rule.getPattern())) {
                        if (configureRule) {
                            FilterGroup newExcludeGroup = FilterGroup.removeRule((FilterGroup)excludeGroup, (FilterRule)rule);
                            validatorTable.replaceFilterGroup(excludeGroup, FilterGroup.addRule((FilterGroup)newExcludeGroup, (FilterRule)folderRule));
                        }
                        hasCustomJSPFolderRule = true;
                        break;
                    }
                    ++n4;
                }
                if (!hasCustomJSPFolderRule && configureRule) {
                    validatorTable.replaceFilterGroup(excludeGroup, FilterGroup.addRule((FilterGroup)excludeGroup, (FilterRule)folderRule));
                    hasCustomJSPFolderRule = true;
                }
                retval = hasCustomJSPFolderRule;
            }
            if (configureRule) {
                ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(project);
                pc.setDoesProjectOverride(true);
                ProjectPreferences pp = new ProjectPreferences(project, true, false, null);
                ValPrefManagerProject vpm = new ValPrefManagerProject(project);
                ValidatorMutable[] validatorTables = new ValidatorMutable[]{validatorTable};
                vpm.savePreferences(pp, validatorTables);
            }
        }
        catch (Exception e) {
            HookCore.logError("Unable to configure jsp syntax validation folder exclude rule.", e);
        }
        return retval;
    }

    public static IFolder getCustomJspFolder(Hook hook, IProject project) {
        IFolder defaultDocroot;
        IWebProject webproject;
        CustomJspDir element = (CustomJspDir)hook.getCustomJspDir().content();
        if (element != null && !element.getValue().empty() && (webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project)) != null && webproject.getDefaultDocrootFolder() != null && (defaultDocroot = webproject.getDefaultDocrootFolder()) != null) {
            org.eclipse.sapphire.modeling.Path customJspDir = (org.eclipse.sapphire.modeling.Path)element.getValue().content();
            return defaultDocroot.getFolder(customJspDir.toPortableString());
        }
        return null;
    }

    public static IPath getCustomJspPath(IProject project) {
        IFolder docFolder;
        HookDescriptorHelper hookDescriptor = new HookDescriptorHelper(project);
        String customJSPFolder = hookDescriptor.getCustomJSPFolder(null);
        if (customJSPFolder != null && (docFolder = CoreUtil.getDefaultDocrootFolder((IProject)project)) != null) {
            IPath newPath = Path.fromOSString((String)customJSPFolder);
            IPath pathValue = docFolder.getFullPath().append(newPath);
            return pathValue;
        }
        return null;
    }

    public static String getDTDVersion(Document document) {
        String dtdVersion = null;
        DocumentType docType = document.getDoctype();
        if (docType != null) {
            String publicId = docType.getPublicId();
            String systemId = docType.getSystemId();
            if (publicId != null && systemId != null) {
                if (publicId.contains("6.0.0") || systemId.contains("6.0.0")) {
                    dtdVersion = "6.0.0";
                } else if (publicId.contains("6.1.0") || systemId.contains("6.1.0")) {
                    dtdVersion = "6.1.0";
                }
            }
        }
        return dtdVersion;
    }
}

