/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.server.core.portal.JMXBundleDeployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.jar.JarInputStream;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.dto.BundleDTO;

public class BundleDeployer
extends JMXBundleDeployer {
    private static final String OBJECTNAME = "osgi.core";

    public BundleDeployer(int jmxRemotePort) {
        super(jmxRemotePort);
    }

    @Override
    public long deploy(String bsn, String bundleUrl) throws Exception {
        MBeanServerConnection connection = this.mBeanServerConnection;
        ObjectName framework = BundleDeployer.getFramework(connection);
        long bundleId = -1L;
        BundleDTO[] bundleDTOArray = this.listBundles();
        int n = bundleDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDTO osgiBundle = bundleDTOArray[n2];
            if (osgiBundle.symbolicName.equals(bsn)) {
                bundleId = osgiBundle.id;
                break;
            }
            ++n2;
        }
        boolean isFragment = false;
        if (!bundleUrl.contains("webbundle:")) {
            File bundleFile = new File(new URL(bundleUrl).toURI());
            try {
                Throwable throwable = null;
                bundleDTOArray = null;
                try (JarInputStream jarStream = new JarInputStream(new FileInputStream(bundleFile));){
                    isFragment = jarStream.getManifest().getMainAttributes().getValue("Fragment-Host") != null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        if (bundleId > -1L) {
            if (!isFragment) {
                connection.invoke(framework, "stopBundle", new Object[]{bundleId}, new String[]{"long"});
            }
            connection.invoke(framework, "updateBundleFromURL", new Object[]{bundleId, bundleUrl}, new String[]{"long", String.class.getName()});
            connection.invoke(framework, "refreshBundle", new Object[]{bundleId}, new String[]{"long"});
        } else {
            Object installed = connection.invoke(framework, "installBundleFromURL", new Object[]{bundleUrl, bundleUrl}, new String[]{String.class.getName(), String.class.getName()});
            bundleId = Long.parseLong(installed.toString());
        }
        if (!isFragment) {
            connection.invoke(framework, "startBundle", new Object[]{bundleId}, new String[]{"long"});
        }
        return bundleId;
    }

    private static ObjectName getFramework(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        ObjectName objectName = new ObjectName("osgi.core:type=framework,*");
        Set<ObjectName> objectNames = mBeanServerConnection.queryNames(objectName, null);
        if (objectNames != null && objectNames.size() > 0) {
            return objectNames.iterator().next();
        }
        return null;
    }

    public boolean ping() {
        try {
            return this.mBeanServerConnection != null && this.mBeanServerConnection.queryNames(new ObjectName("osgi.core:type=bundleState,*"), null) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

