/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.remote;

import com.liferay.ide.core.remote.APIException;
import com.liferay.ide.core.remote.RemoteConnection;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.remote.IServerManagerConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerManagerConnection
extends RemoteConnection
implements IServerManagerConnection {
    private String managerContextPath;

    public ServerManagerConnection() {
        this(null, null, null, null, null);
    }

    public ServerManagerConnection(String host, String httpPort, String username, String pw, String managerContextPath) {
        this.setHost(host);
        this.setHttpPort(httpPort);
        this.setUsername(username);
        this.setPassword(pw);
        this.managerContextPath = managerContextPath;
    }

    @Override
    public int getDebugPort() throws APIException {
        String debugPort = this.getRemoteServerConfig(this.getDebugPortAPI());
        if (debugPort != null) {
            return Integer.parseInt(debugPort);
        }
        return -1;
    }

    private String getDebugPortAPI() {
        return String.valueOf(this.managerContextPath) + "/server/debug-port";
    }

    private String getDeployURI(String appName) {
        return String.valueOf(this.getPluginsAPI()) + "/" + appName;
    }

    @Override
    public String getFMDebugPassword() throws APIException {
        return this.getRemoteServerConfig(this.getFMDebugPasswordAPI());
    }

    private String getFMDebugPasswordAPI() {
        return String.valueOf(this.managerContextPath) + "/server/freemarker/debug-password";
    }

    @Override
    public int getFMDebugPort() throws APIException {
        String fmDebugPort = this.getRemoteServerConfig(this.getFMDebugPortAPI());
        if (fmDebugPort != null) {
            return Integer.parseInt(fmDebugPort);
        }
        return -1;
    }

    private String getFMDebugPortAPI() {
        return String.valueOf(this.managerContextPath) + "/server/freemarker/debug-port";
    }

    private String getIsAliveAPI() {
        return String.valueOf(this.managerContextPath) + "/status";
    }

    private <T> T getJSONOutput(JSONObject jsonObject) throws JSONException {
        if (jsonObject.has("output")) {
            return (T)jsonObject.get("output");
        }
        return null;
    }

    @Override
    public List<String> getLiferayPlugins() {
        ArrayList<String> retval = new ArrayList<String>();
        Object response = null;
        try {
            response = this.getJSONAPI(new Object[]{this.getPluginsAPI()});
        }
        catch (APIException e1) {
            LiferayServerCore.logError((Exception)((Object)e1));
        }
        if (response instanceof JSONObject) {
            JSONObject json = (JSONObject)response;
            try {
                if (this.isSuccess(json)) {
                    JSONArray jsonPlugins = (JSONArray)this.getJSONOutput(json);
                    int i = 0;
                    while (i < jsonPlugins.length()) {
                        retval.add(jsonPlugins.get(i).toString());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                LiferayServerCore.logError(e);
            }
        }
        return retval;
    }

    @Override
    public String getManagerURI() {
        return "http://" + this.getHost() + ":" + this.getHttpPort() + this.managerContextPath;
    }

    private String getPluginsAPI() {
        return String.valueOf(this.managerContextPath) + "/plugins";
    }

    private String getPluginURI(String appName) {
        return String.valueOf(this.getPluginsAPI()) + "/" + appName;
    }

    @Override
    public String getRemoteServerConfig(String configAPI) throws APIException {
        Object response;
        if (this.isAlive() && (response = this.getJSONAPI(new Object[]{configAPI})) instanceof JSONObject) {
            JSONObject jsonResponse = (JSONObject)response;
            try {
                if (this.isSuccess(jsonResponse)) {
                    return (String)this.getJSONOutput(jsonResponse);
                }
            }
            catch (JSONException e) {
                throw new APIException(configAPI, (Exception)((Object)e));
            }
        }
        return null;
    }

    @Override
    public String getServerState() throws APIException {
        if (this.isAlive()) {
            return "STARTED";
        }
        return "STOPPED";
    }

    private String getUndeployURI(String appName) {
        return this.getDeployURI(appName);
    }

    private String getUpdateURI(String appName) {
        return this.getDeployURI(appName);
    }

    @Override
    public Object installApplication(String absolutePath, String appName, IProgressMonitor submon) throws APIException {
        try {
            FileBody fileBody = new FileBody(new File(absolutePath));
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("deployWar", (ContentBody)fileBody);
            HttpPost httpPost = new HttpPost();
            httpPost.setEntity((HttpEntity)entity);
            Object response = this.httpJSONAPI(new Object[]{httpPost, this.getDeployURI(appName)});
            if (response instanceof JSONObject) {
                JSONObject json = (JSONObject)response;
                if (this.isSuccess(json)) {
                    System.out.println("installApplication: Sucess.\n\n");
                } else {
                    if (this.isError(json)) {
                        return json.getString("error");
                    }
                    return "installApplication error " + this.getDeployURI(appName);
                }
            }
            httpPost.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    @Override
    public boolean isAlive() throws APIException {
        JSONObject status = null;
        Object jsonResponse = this.getJSONAPI(new Object[]{this.getIsAliveAPI()});
        if (!(jsonResponse instanceof JSONObject)) {
            throw new APIException(this.getIsAliveAPI(), "Unable to connect to server manager.");
        }
        status = (JSONObject)jsonResponse;
        return this.isSuccess(status);
    }

    @Override
    public boolean isAppInstalled(String appName) throws APIException {
        Object response = this.getJSONAPI(new Object[]{this.getPluginURI(appName)});
        if (response instanceof JSONObject) {
            JSONObject json = (JSONObject)response;
            try {
                if (this.isSuccess(json)) {
                    JSONObject output = (JSONObject)this.getJSONOutput(json);
                    return output.getBoolean("installed");
                }
            }
            catch (Exception e) {
                throw new APIException(this.getPluginURI(appName), e);
            }
        }
        return false;
    }

    private boolean isError(JSONObject jsonObject) {
        try {
            String error = jsonObject.getString("error");
            return !CoreUtil.isNullOrEmpty((String)error);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    @Override
    public boolean isLiferayPluginStarted(String appName) throws APIException {
        Object response = this.getJSONAPI(new Object[]{this.getPluginURI(appName)});
        if (response instanceof JSONObject) {
            JSONObject json = (JSONObject)response;
            try {
                JSONObject jsonOutput;
                boolean installed;
                if (this.isSuccess(json) && (installed = (jsonOutput = (JSONObject)this.getJSONOutput(json)).getBoolean("started"))) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new APIException(this.getPluginURI(appName), e);
            }
        }
        return false;
    }

    private boolean isSuccess(JSONObject jsonObject) {
        try {
            return jsonObject.getInt("status") == 0;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    @Override
    public void setManagerContextPath(String managerContextPath) {
        this.managerContextPath = managerContextPath;
    }

    @Override
    public Object uninstallApplication(String appName, IProgressMonitor monitor) throws APIException {
        Object response = this.deleteJSONAPI(new Object[]{this.getUndeployURI(appName)});
        if (response instanceof JSONObject) {
            JSONObject json = (JSONObject)response;
            try {
                if (!this.isSuccess(json)) {
                    if (this.isError(json)) {
                        return json.getString("error");
                    }
                    return "uninstallApplication error " + this.getDeployURI(appName);
                }
                System.out.println("uninstallApplication: success\n\n");
            }
            catch (Exception e) {
                throw new APIException(this.getUndeployURI(appName), e);
            }
        }
        return null;
    }

    @Override
    public Object updateApplication(String appName, String absolutePath, IProgressMonitor monitor) throws APIException {
        try {
            File file = new File(absolutePath);
            FileBody fileBody = new FileBody(file);
            MultipartEntity entity = new MultipartEntity();
            entity.addPart(file.getName(), (ContentBody)fileBody);
            HttpPut httpPut = new HttpPut();
            httpPut.setEntity((HttpEntity)entity);
            Object response = this.httpJSONAPI(new Object[]{httpPut, this.getUpdateURI(appName)});
            if (response instanceof JSONObject) {
                JSONObject json = (JSONObject)response;
                if (this.isSuccess(json)) {
                    System.out.println("updateApplication: success.\n\n");
                } else {
                    if (this.isError(json)) {
                        return json.getString("error");
                    }
                    return "updateApplication error " + this.getDeployURI(appName);
                }
            }
            httpPut.releaseConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }
}

