/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.action;

import com.liferay.ide.portlet.ui.PortletUIPlugin;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class HierarchyBrowseActionHandler
extends BrowseActionHandler {
    public static final String ID = "Hierarchy.Browse.Java.Type";

    public String browse(Presentation context) {
        Element element = this.getModelElement();
        Value property = this.property();
        IProject project = (IProject)element.adapt(IProject.class);
        IJavaSearchScope scope = null;
        TypeSelectionExtension extension = null;
        String javaType = this.getClassReferenceType((Property)property);
        if (javaType == null) {
            MessageDialog.openInformation((Shell)((SwtPresentation)context).shell(), (String)Msgs.browseImplementation, (String)Msgs.validClassImplProperty);
            return null;
        }
        scope = SearchEngine.createHierarchyScope((IType)JavaCore.create((IProject)project).findType(javaType));
        try {
            SelectionDialog dlg = JavaUI.createTypeDialog((Shell)((SwtPresentation)context).shell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"**", extension);
            String title = property.definition().getLabel(true, CapitalizationType.TITLE_STYLE, false);
            dlg.setTitle(String.valueOf(Msgs.select) + title);
            if (dlg.open() == 0) {
                Object[] results = dlg.getResult();
                assert (results != null && results.length == 1);
                if (results[0] instanceof IType) {
                    return ((IType)results[0]).getFullyQualifiedName();
                }
            }
        }
        catch (JavaModelException e) {
            PortletUIPlugin.logError((Exception)((Object)e));
        }
        return null;
    }

    private String getClassReferenceType(Property property) {
        JavaTypeConstraint typeConstraint = (JavaTypeConstraint)property.definition().getAnnotation(JavaTypeConstraint.class);
        String retval = Arrays.toString(typeConstraint.type()).replaceAll("[\\[\\]\\s,]", "");
        return retval;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
    }

    private static class Msgs
    extends NLS {
        public static String browseImplementation;
        public static String select;
        public static String validClassImplProperty;

        static {
            Msgs.initializeMessages((String)HierarchyBrowseActionHandler.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

