/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.handlers;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.job.BuildLanguageJob;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.ui.util.UIUtil;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class BuildLangHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput activeInput;
        IFile file;
        IStatus retval = null;
        IProject project = null;
        IFile langFile = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object selected = structuredSelection.getFirstElement();
            if (selected instanceof IResource) {
                project = ((IResource)selected).getProject();
            } else if (selected instanceof IJavaElement) {
                project = ((IJavaElement)selected).getJavaProject().getProject();
            } else if (selected instanceof PackageFragmentRootContainer) {
                project = ((PackageFragmentRootContainer)selected).getJavaProject().getProject();
            }
        }
        if (project == null && (file = (IFile)(activeInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)).getAdapter(IFile.class)) != null) {
            project = file.getProject();
        }
        if (project != null) {
            List srcFolders = CoreUtil.getSourceFolders((IJavaProject)JavaCore.create(project));
            for (IFolder src : srcFolders) {
                IFile file2 = src.getFile("content/Language.properties");
                if (!file2.exists()) continue;
                langFile = file2;
                break;
            }
            if (langFile != null && langFile.exists()) {
                try {
                    boolean shouldContinue = this.checkLanguageFileEncoding(langFile);
                    if (!shouldContinue) {
                        retval = Status.OK_STATUS;
                    }
                    BuildLanguageJob job = PortletCore.createBuildLanguageJob((IFile)langFile);
                    job.schedule();
                }
                catch (Exception e2) {
                    retval = PortletUIPlugin.createErrorStatus(e2);
                }
            }
        }
        return retval;
    }

    protected boolean checkLanguageFileEncoding(IFile langFile) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            langFile.refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            PortletUIPlugin.logError(e);
        }
        String charset = langFile.getCharset(true);
        if (!"UTF-8".equals(charset)) {
            String dialogMessage = NLS.bind((String)Msgs.languageFileCharacterSet, (Object)charset);
            MessageDialog dialog = new MessageDialog(UIUtil.getActiveShell(), Msgs.incompatibleCharacterSet, UIUtil.getActiveShell().getDisplay().getSystemImage(8), dialogMessage, 4, new String[]{Msgs.yes, Msgs.no, Msgs.cancel}, 0);
            int retval = dialog.open();
            if (retval == 0) {
                langFile.setCharset("UTF-8", (IProgressMonitor)monitor);
                String question = NLS.bind((String)Msgs.forcedEditFile, (Object)langFile.getName());
                if (MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)Msgs.previewFile, (String)question)) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)langFile);
                }
                return false;
            }
            if (retval == 2) {
                return false;
            }
        }
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String cancel;
        public static String forcedEditFile;
        public static String incompatibleCharacterSet;
        public static String languageFileCharacterSet;
        public static String no;
        public static String previewFile;
        public static String yes;

        static {
            Msgs.initializeMessages((String)BuildLangHandler.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

