/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesDiscoveryStrategy
extends MarketplaceDiscoveryStrategy {
    private String favoritesReference;

    public FavoritesDiscoveryStrategy(CatalogDescriptor catalogDescriptor) {
        super(catalogDescriptor);
    }

    public FavoritesDiscoveryStrategy(MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy) {
        super(marketplaceDiscoveryStrategy.catalogDescriptor);
    }

    public void setFavoritesReference(String favoritesReference) {
        this.favoritesReference = favoritesReference;
    }

    public String getFavoritesReference() {
        return this.favoritesReference;
    }

    @Override
    public void maybeAddCatalogItem(MarketplaceCategory catalogCategory) {
    }

    @Override
    protected Map<String, IInstallableUnit> computeInstalledIUs(IProgressMonitor monitor) {
        return Collections.emptyMap();
    }

    @Override
    protected void handleDiscoveryCategory(MarketplaceCategory catalogCategory) {
        catalogCategory.setContents(MarketplaceCategory.Contents.USER_FAVORITES);
    }

    @Override
    protected ISearchResult doPerformDiscovery(IProgressMonitor monitor) throws CoreException {
        this.preDiscovery();
        if (this.favoritesReference == null) {
            return null;
        }
        try {
            URI uri = URLUtil.toURI((String)this.favoritesReference);
            ISearchResult iSearchResult = this.marketplaceService.userFavorites(uri, monitor);
            return iSearchResult;
        }
        catch (CoreException ex) {
            this.handleDiscoveryError(ex);
            return null;
        }
        catch (URISyntaxException e) {
            Status error = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.FavoritesDiscoveryStrategy_invalidUrl, (Object)this.favoritesReference, (Object)e), (Throwable)e);
            this.handleDiscoveryError(new CoreException((IStatus)error));
            return null;
        }
        finally {
            this.postDiscovery();
        }
    }

    protected void postDiscovery() {
    }

    protected void preDiscovery() {
    }

    protected void handleDiscoveryError(CoreException ex) throws CoreException {
        throw ex;
    }

    @Override
    protected void handleSearchResult(MarketplaceCategory catalogCategory, ISearchResult result, IProgressMonitor monitor) {
        if (result == null) {
            this.addInstructionInfoItem(catalogCategory);
        } else if (result.getNodes().isEmpty()) {
            this.addEmptyInfoItem(catalogCategory);
        } else {
            super.handleSearchResult(catalogCategory, result, monitor);
            for (CatalogItem catalogItem : this.items) {
                if (!(catalogItem instanceof MarketplaceNodeCatalogItem)) continue;
                catalogItem.setSelected(true);
            }
        }
    }

    private void addEmptyInfoItem(CatalogCategory catalogCategory) {
        this.addInfoItem(catalogCategory, Messages.FavoritesDiscoveryStrategy_noFavoritesMessage);
    }

    private void addInstructionInfoItem(CatalogCategory catalogCategory) {
        this.addInfoItem(catalogCategory, Messages.FavoritesDiscoveryStrategy_enterFavoritesUrlMessage);
    }

    private void addInfoItem(CatalogCategory catalogCategory, String label) {
        UserActionCatalogItem infoItem = new UserActionCatalogItem();
        infoItem.setUserAction(UserActionCatalogItem.UserAction.INFO);
        infoItem.setDescription(label);
        infoItem.setSource(this.getCatalogSource());
        infoItem.setId(String.valueOf(this.catalogDescriptor.getUrl().toString()) + "#info:" + label);
        infoItem.setCategoryId(catalogCategory.getId());
        this.items.add(infoItem);
    }
}

