/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

public class WikiTemplateResolver
extends TemplateResolver {
    private String wikiBaseUrl;

    public String getWikiBaseUrl() {
        return this.wikiBaseUrl;
    }

    public void setWikiBaseUrl(String wikiBaseUrl) {
        this.wikiBaseUrl = wikiBaseUrl;
    }

    @Override
    public Template resolveTemplate(String templateName) {
        if (this.wikiBaseUrl != null) {
            int indexOf = templateName.indexOf(58);
            if (indexOf == 0) {
                templateName = templateName.substring(1);
            } else if (indexOf == -1) {
                templateName = "Template:" + templateName;
            }
            URL url = this.computeRawUrl(templateName);
            if (url != null) {
                try {
                    String content = this.readContent(url);
                    Template template = new Template();
                    String basicName = templateName.toLowerCase().startsWith("template:") ? templateName.substring(templateName.lastIndexOf(58) + 1) : templateName;
                    template.setName(basicName);
                    template.setTemplateMarkup(content);
                    return template;
                }
                catch (IOException e) {
                    String message = MessageFormat.format("Cannot read from {0}: {1}", url, e.getMessage());
                    Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, message, e);
                }
            }
        }
        return null;
    }

    protected String readContent(URL url) throws IOException {
        return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
    }

    private URL computeRawUrl(String path) {
        try {
            String qualifiedUrl = this.wikiBaseUrl;
            if (!qualifiedUrl.endsWith("/")) {
                qualifiedUrl = String.valueOf(qualifiedUrl) + "/";
            }
            qualifiedUrl = String.valueOf(qualifiedUrl) + "index.php?title=" + URLEncoder.encode(path, "UTF-8") + "&action=raw";
            return new URL(qualifiedUrl);
        }
        catch (IOException e) {
            Logger.getLogger(WikiTemplateResolver.class.getName()).log(Level.WARNING, MessageFormat.format("Cannot compute raw URL for {0}: {1}", path, e.getMessage()), e);
            return null;
        }
    }
}

