/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.descriptor.RemoveSampleElementsOperation;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.Profile;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.osgi.framework.Version;

public class NewLiferayPluginProjectOpMethods {
    public static boolean canUseCustomLocation(NewLiferayPluginProjectOp op) {
        boolean retval = false;
        if (((NewLiferayProjectProvider)op.getProjectProvider().content(true)).getShortName().equals("maven")) {
            retval = true;
        }
        return retval;
    }

    public static final org.eclipse.sapphire.modeling.Status execute(NewLiferayPluginProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay plugin project (this process may take several minutes)", 100);
        org.eclipse.sapphire.modeling.Status retval = null;
        try {
            NewLiferayProjectProvider projectProvider = (NewLiferayProjectProvider)op.getProjectProvider().content(true);
            Path projectLocation = (Path)op.getLocation().content();
            NewLiferayPluginProjectOpMethods.updateLocation(op, projectLocation);
            IStatus status = projectProvider.createNewProject(op, monitor);
            if (status.isOK()) {
                NewLiferayPluginProjectOpMethods.updateProjectPrefs(op);
                NewLiferayPluginProjectOpMethods.removeSampleCodeAndFiles(op);
                op.setImportProjectStatus(true);
            }
            retval = StatusBridge.create((IStatus)status);
        }
        catch (Exception e) {
            String msg = "Error creating Liferay plugin project.";
            ProjectCore.logError("Error creating Liferay plugin project.", e);
            return org.eclipse.sapphire.modeling.Status.createErrorStatus((String)"Error creating Liferay plugin project. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }

    public static String getFrameworkName(NewLiferayPluginProjectOp op) {
        IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content();
        String frameworkName = portletFramework.getShortName();
        if (portletFramework.isRequiresAdvanced()) {
            frameworkName = ((IPortletFramework)op.getPortletFrameworkAdvanced().content()).getShortName();
        }
        return frameworkName;
    }

    public static String getMavenParentPomGroupId(NewLiferayPluginProjectOp op, String projectName, IPath path) {
        List groupId;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !(groupId = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentGroupId", String.class, new Object[]{parentProjectDir})).isEmpty()) {
            retval = (String)groupId.get(0);
        }
        return retval;
    }

    public static String getMavenParentPomVersion(NewLiferayPluginProjectOp op, String projectName, IPath path) {
        List version;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !(version = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentVersion", String.class, new Object[]{parentProjectDir})).isEmpty()) {
            retval = (String)version.get(0);
        }
        return retval;
    }

    public static String getPluginTypeSuffix(PluginType pluginType) {
        String suffix = null;
        switch (pluginType) {
            case portlet: 
            case servicebuilder: {
                suffix = "-portlet";
                break;
            }
            case ext: {
                suffix = "-ext";
                break;
            }
            case hook: {
                suffix = "-hook";
                break;
            }
            case layouttpl: {
                suffix = "-layouttpl";
                break;
            }
            case theme: {
                suffix = "-theme";
                break;
            }
            case web: {
                suffix = "-web";
            }
        }
        return suffix;
    }

    public static Set<String> getPossibleProfileIds(NewLiferayPluginProjectOp op, boolean includeNewProfiles) {
        Object[] vals;
        String activeProfilesValue = (String)op.getActiveProfilesValue().content();
        Path currentLocation = (Path)op.getLocation().content();
        File param = currentLocation != null ? currentLocation.toFile() : null;
        List systemProfileIds = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("profileIds", String.class, new Object[]{param});
        ElementList<NewLiferayProfile> newLiferayProfiles = op.getNewLiferayProfiles();
        HashSet<String> possibleProfileIds = new HashSet<String>();
        if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue) && !CoreUtil.isNullOrEmpty((Object[])(vals = activeProfilesValue.split(",")))) {
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray[n2];
                if (!possibleProfileIds.contains(val) && !((String)val).contains(" ")) {
                    possibleProfileIds.add((String)val);
                }
                ++n2;
            }
        }
        if (!CoreUtil.isNullOrEmpty((List)systemProfileIds)) {
            for (Object systemProfileId : systemProfileIds) {
                String val;
                if (systemProfileId == null || possibleProfileIds.contains(val = systemProfileId.toString()) || val.contains(" ")) continue;
                possibleProfileIds.add(val);
            }
        }
        if (includeNewProfiles) {
            for (NewLiferayProfile newLiferayProfile : newLiferayProfiles) {
                String newId = (String)newLiferayProfile.getId().content();
                if (CoreUtil.isNullOrEmpty((String)newId) || possibleProfileIds.contains(newId) || newId.contains(" ")) continue;
                possibleProfileIds.add(newId);
            }
        }
        return possibleProfileIds;
    }

    public static String getProjectNameWithSuffix(NewLiferayPluginProjectOp op) {
        String projectName = (String)op.getProjectName().content();
        String suffix = null;
        if (projectName != null && "ant".equals(((NewLiferayProjectProvider)op.getProjectProvider().content(true)).getShortName()) && (suffix = NewLiferayPluginProjectOpMethods.getPluginTypeSuffix((PluginType)((Object)op.getPluginType().content(true)))) != null && projectName.endsWith(suffix)) {
            suffix = null;
        }
        return String.valueOf(projectName == null ? "" : projectName) + (suffix == null ? "" : suffix);
    }

    private static IStatus removeSampleCodeAndFiles(NewLiferayPluginProjectOp op) {
        IProject project;
        IStatus status = Status.OK_STATUS;
        boolean includeSampleCode = (Boolean)op.getIncludeSampleCode().content();
        if (!includeSampleCode && (project = CoreUtil.getLiferayProject((String)((String)op.getFinalProjectName().content()))) != null && project.exists()) {
            ProjectCore.operate(project, RemoveSampleElementsOperation.class, new Object[0]);
            try {
                IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
                if (webproject != null) {
                    IFile[] sampleFiles;
                    IFolder docroot = webproject.getDefaultDocrootFolder();
                    IFile[] iFileArray = sampleFiles = new IFile[]{docroot.getFile("view.jsp"), docroot.getFile("css/main.css"), docroot.getFile("js/main.js")};
                    int n = sampleFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        if (file != null && file.exists()) {
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            if (file.getParent().members().length == 0) {
                                CoreUtil.deleteResource((IResource)file.getParent());
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                ProjectCore.logError("Error deleting sample files.", (Exception)((Object)e));
            }
        }
        return status;
    }

    public static boolean supportsTypePlugin(NewLiferayPluginProjectOp op, String type) {
        boolean retval = false;
        if (((NewLiferayProjectProvider)op.getProjectProvider().content(true)).getShortName().equals("maven")) {
            if (type.equals("web") || type.equals("theme")) {
                retval = true;
            }
        } else {
            Path sdkLocation;
            SDK sdk = null;
            try {
                sdk = SDKUtil.getWorkspaceSDK();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (sdk == null && (sdkLocation = (Path)op.getSdkLocation().content()) != null) {
                sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation));
            }
            if (sdk != null) {
                boolean greaterThan700;
                Version version = new Version(sdk.getVersion());
                boolean bl = greaterThan700 = CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V700) >= 0;
                if (greaterThan700 && "web".equals(type) || !greaterThan700 && "theme".equals(type)) {
                    retval = true;
                }
                if (greaterThan700 && "ext".equals(type)) {
                    IPath extFolder = sdk.getLocation().append("ext");
                    if (extFolder.toFile().exists() && extFolder.append("build.xml").toFile().exists()) {
                        retval = true;
                    }
                } else if (!greaterThan700 && "ext".equals(type)) {
                    retval = true;
                }
            } else {
                retval = true;
            }
        }
        return retval;
    }

    public static void updateActiveProfilesValue(NewLiferayPluginProjectOp op, ElementList<Profile> profiles) {
        StringBuilder sb = new StringBuilder();
        if (profiles.size() > 0) {
            for (Profile profile : profiles) {
                if (profile.getId().empty()) continue;
                sb.append((String)profile.getId().content());
                sb.append(',');
            }
        }
        op.setActiveProfilesValue(sb.toString().replaceAll("(.*),$", "$1"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateLocation(NewLiferayPluginProjectOp op) {
        String currentProjectName = (String)op.getProjectName().content();
        if (currentProjectName == null) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        String providerShortName = ((NewLiferayProjectProvider)op.getProjectProvider().content(true)).getShortName();
        if (!useDefaultLocation) return;
        Path newLocationBase = null;
        if (providerShortName.equals("ant")) {
            Path sdkPath;
            SDK sdk = null;
            try {
                IStatus sdkStatus;
                sdk = SDKUtil.getWorkspaceSDK();
                if (sdk != null && !(sdkStatus = sdk.validate()).isOK()) {
                    sdk = null;
                }
            }
            catch (CoreException sdkStatus) {
                // empty catch block
            }
            if (sdk == null && op.getSdkLocation() != null && (sdkPath = (Path)op.getSdkLocation().content()) != null) {
                IPath sdkLocation = PathBridge.create((Path)sdkPath);
                sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
            }
            if (sdk == null) return;
            Path sdkLocation = PathBridge.create((IPath)sdk.getLocation());
            switch ((PluginType)((Object)op.getPluginType().content(true))) {
                case portlet: 
                case servicebuilder: {
                    newLocationBase = sdkLocation.append("portlets");
                    break;
                }
                case ext: {
                    newLocationBase = sdkLocation.append("ext");
                    break;
                }
                case hook: {
                    newLocationBase = sdkLocation.append("hooks");
                    break;
                }
                case layouttpl: {
                    newLocationBase = sdkLocation.append("layouttpl");
                    break;
                }
                case theme: {
                    newLocationBase = sdkLocation.append("themes");
                    break;
                }
                case web: {
                    newLocationBase = sdkLocation.append("webs");
                }
            }
        } else {
            newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
        }
        if (newLocationBase == null) return;
        NewLiferayPluginProjectOpMethods.updateLocation(op, newLocationBase);
    }

    public static void updateLocation(NewLiferayPluginProjectOp op, Path baseLocation) {
        String projectName = NewLiferayPluginProjectOpMethods.getProjectNameWithSuffix(op);
        if (baseLocation == null) {
            return;
        }
        String lastSegment = baseLocation.lastSegment();
        if (baseLocation != null && baseLocation.segmentCount() > 0 && lastSegment.equals(projectName)) {
            return;
        }
        Path newLocation = baseLocation.append(projectName);
        op.setLocation(newLocation);
    }

    private static void updateProjectPrefs(NewLiferayPluginProjectOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-plugin_default-build-type-option", op.getProjectProvider().text());
            prefs.putBoolean("include-sample-code", ((Boolean)op.getIncludeSampleCode().content()).booleanValue());
            prefs.putBoolean("create-new-portlet", ((Boolean)op.getCreateNewPortlet().content()).booleanValue());
            if ("maven".equalsIgnoreCase(op.getProjectProvider().text())) {
                prefs.put("default-plugin-project-maven-groupid", (String)op.getGroupId().content());
            }
            prefs.flush();
        }
        catch (Exception e) {
            String msg = "Error updating default project build type.";
            ProjectCore.logError("Error updating default project build type.", e);
        }
    }
}

