/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ProjectNameValidationService
extends ValidationService {
    private static final String MAVEN_PROJECT_NAME_REGEX = "[A-Za-z0-9_\\-.]+";
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!(event.property().definition().equals(NewLiferayPluginProjectOp.PROP_DISPLAY_NAME) || event.property().definition().equals(NewLiferayPluginProjectOp.PROP_FINAL_PROJECT_NAME) || event.property().definition().equals(NewLiferayPluginProjectOp.PROP_PORTLET_NAME) || event.property().definition().equals(NewLiferayPluginProjectOp.PROP_PROJECT_NAMES) || event.property().definition().equals(NewLiferayPluginProjectOp.PROP_PROJECT_NAME))) {
                    try {
                        ProjectNameValidationService.this.refresh();
                    }
                    catch (Exception e) {
                        ProjectCore.logError(e);
                    }
                }
            }
        };
        this.op().attach((Listener)this.listener, "*");
    }

    protected Status compute() {
        String currentProjectName;
        Status retval = Status.createOkStatus();
        NewLiferayPluginProjectOp op = this.op();
        if (((NewLiferayProjectProvider)this.op().getProjectProvider().content()).getShortName().equals("ant")) {
            SDK sdk = null;
            try {
                IStatus sdkStatus;
                sdk = SDKUtil.getWorkspaceSDK();
                if (sdk != null && !(sdkStatus = sdk.validate()).isOK()) {
                    retval = Status.createErrorStatus((String)sdkStatus.getChildren()[0].getMessage());
                }
            }
            catch (CoreException e) {
                retval = Status.createErrorStatus((Throwable)e);
            }
        }
        if ((currentProjectName = (String)op.getProjectName().content()) != null) {
            IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentProjectName, 4);
            if (!nameStatus.isOK()) {
                retval = StatusBridge.create((IStatus)nameStatus);
            } else if (this.isInvalidProjectName(op)) {
                Boolean projectImported = (Boolean)op.getImportProjectStatus().content();
                if (!projectImported.booleanValue()) {
                    retval = Status.createErrorStatus((String)"A project with that name already exists.");
                }
            } else if (this.isAntProject(op) && this.isSuffixOnly(currentProjectName)) {
                retval = Status.createErrorStatus((String)"A project name cannot only be a type suffix.");
            } else if (!this.hasValidDisplayName(currentProjectName)) {
                retval = Status.createErrorStatus((String)"The project name is invalid.");
            } else if (this.isMavenProject(op) && !this.isValidMavenProjectName(currentProjectName)) {
                retval = Status.createErrorStatus((String)"The project name is invalid for a maven project");
            } else {
                org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)op.getLocation().content(true);
                if (currentProjectName != null && currentProjectLocation != null) {
                    String currentPath = currentProjectLocation.toOSString();
                    IPath osPath = Path.fromOSString((String)currentPath);
                    IStatus projectStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(currentProjectName, osPath);
                    if (!projectStatus.isOK()) {
                        retval = StatusBridge.create((IStatus)projectStatus);
                    }
                }
            }
        }
        op.getSdkLocation().refresh();
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.op().detach((Listener)this.listener, "*");
    }

    private boolean hasValidDisplayName(String currentProjectName) {
        String currentDisplayName = ProjectUtil.convertToDisplayName(currentProjectName);
        return !CoreUtil.isNullOrEmpty((String)currentDisplayName);
    }

    private boolean isAntProject(NewLiferayPluginProjectOp op) {
        return "ant".equals(((NewLiferayProjectProvider)op.getProjectProvider().content()).getShortName());
    }

    private boolean isInvalidProjectName(NewLiferayPluginProjectOp op) {
        String projectName = (String)op.getProjectName().content();
        if (CoreUtil.getProject((String)projectName).exists()) {
            return true;
        }
        if ("ant".equals(((NewLiferayProjectProvider)op.getProjectProvider().content()).getShortName())) {
            String pluginTypeValue;
            switch ((PluginType)((Object)op.getPluginType().content())) {
                case portlet: 
                case servicebuilder: {
                    pluginTypeValue = "-portlet";
                    break;
                }
                case hook: {
                    pluginTypeValue = "-hook";
                    break;
                }
                case ext: {
                    pluginTypeValue = "-ext";
                    break;
                }
                case layouttpl: {
                    pluginTypeValue = "-layouttpl";
                    break;
                }
                case theme: {
                    pluginTypeValue = "-theme";
                    break;
                }
                case web: {
                    pluginTypeValue = "-web";
                    break;
                }
                default: {
                    pluginTypeValue = "-portlet";
                }
            }
            if (!projectName.endsWith(pluginTypeValue)) {
                return CoreUtil.getProject((String)(String.valueOf(projectName) + pluginTypeValue)).exists();
            }
        }
        return false;
    }

    private boolean isMavenProject(NewLiferayPluginProjectOp op) {
        return "maven".equals(((NewLiferayProjectProvider)op.getProjectProvider().content()).getShortName());
    }

    private boolean isSuffixOnly(String currentProjectName) {
        PluginType[] pluginTypeArray = PluginType.values();
        int n = pluginTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginType type = pluginTypeArray[n2];
            if (!type.equals((Object)PluginType.servicebuilder) && ("-" + type.name()).equals(currentProjectName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidMavenProjectName(String currentProjectName) {
        return currentProjectName.matches(MAVEN_PROJECT_NAME_REGEX);
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

