/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.BaseModuleOp;
import com.liferay.ide.project.core.util.ValidationUtil;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ModuleProjectNameValidationService
extends ValidationService {
    private static final String PROJECT_NAME_REGEX = "([A-Za-z0-9_\\-.]+[A-Za-z0-9]$)|([A-Za-z0-9])";
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!(event.property().definition().equals(BaseModuleOp.PROP_FINAL_PROJECT_NAME) || event.property().definition().equals(BaseModuleOp.PROP_PROJECT_NAMES) || event.property().definition().name().equals("ProjectName") || event.property().definition().equals(ProjectName.PROP_PROJECT_NAME))) {
                    ModuleProjectNameValidationService.this.refresh();
                }
            }
        };
        this.op().attach((Listener)this.listener, "*");
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        String currentProjectName = (String)this.op().getProjectName().content();
        if (!CoreUtil.empty((String)currentProjectName)) {
            IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentProjectName, 4);
            if (!nameStatus.isOK()) {
                return StatusBridge.create((IStatus)nameStatus);
            }
            if (ValidationUtil.isExistingProjectName(currentProjectName)) {
                return Status.createErrorStatus((String)"A project with that name(ignore case) already exists.");
            }
            if (!this.isValidProjectName(currentProjectName)) {
                return Status.createErrorStatus((String)"The project name is invalid.");
            }
            org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)this.op().getLocation().content();
            if (currentProjectLocation != null) {
                String currentPath = currentProjectLocation.toOSString();
                IPath osPath = Path.fromOSString((String)currentPath);
                IStatus projectStatus = ((NewLiferayProjectProvider)this.op().getProjectProvider().content()).validateProjectLocation(currentProjectName, osPath);
                if (!projectStatus.isOK()) {
                    return StatusBridge.create((IStatus)projectStatus);
                }
                File projectFodler = osPath.append(currentProjectName).toFile();
                if (projectFodler.exists() && projectFodler.list().length > 0) {
                    return StatusBridge.create((IStatus)ProjectCore.createErrorStatus("Target project folder is not empty."));
                }
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.op().detach((Listener)this.listener, "*");
    }

    private boolean isValidProjectName(String currentProjectName) {
        return currentProjectName.matches(PROJECT_NAME_REGEX);
    }

    protected BaseModuleOp op() {
        return (BaseModuleOp)this.context(BaseModuleOp.class);
    }
}

