/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.java.JavaPackageName;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class NewLiferayComponentValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                NewLiferayComponentValidationService.this.refresh();
            }
        };
        this.op().property(NewLiferayComponentOp.PROP_PROJECT_NAME).attach(this.listener);
        this.op().property(NewLiferayComponentOp.PROP_PACKAGE_NAME).attach(this.listener);
        this.op().property(NewLiferayComponentOp.PROP_COMPONENT_CLASS_TEMPLATE_NAME).attach(this.listener);
    }

    protected Status compute() {
        IProject project;
        String projectName;
        Status retval = Status.createOkStatus();
        String className = (String)this.op().getComponentClassName().content(true);
        if (!CoreUtil.isNullOrEmpty((String)className)) {
            int classNameStatus = JavaConventions.validateJavaTypeName((String)className, (String)"1.7", (String)"1.7").getSeverity();
            if (className.indexOf(46) != -1) {
                classNameStatus = 4;
            }
            if (classNameStatus == 4) {
                retval = Status.createErrorStatus((String)"Invalid class name");
            }
        }
        if ((projectName = (String)this.op().getProjectName().content(true)) != null && (project = CoreUtil.getProject((String)projectName)) != null) {
            try {
                JavaPackageName pack = (JavaPackageName)this.op().getPackageName().content(true);
                if (pack != null) {
                    String packageName = ((JavaPackageName)this.op().getPackageName().content(true)).toString();
                    IType type = JavaCore.create((IProject)project).findType(String.valueOf(packageName) + "." + className);
                    if (type != null) {
                        retval = Status.createErrorStatus((String)(String.valueOf(packageName) + "." + className + " already existed."));
                    }
                }
            }
            catch (Exception e) {
                ProjectCore.logError("Checking component class name failed.", e);
            }
        }
        return retval;
    }

    public void dispose() {
        if (this.listener != null) {
            this.op().property(NewLiferayComponentOp.PROP_PROJECT_NAME).detach(this.listener);
            this.op().property(NewLiferayComponentOp.PROP_PACKAGE_NAME).detach(this.listener);
            this.op().property(NewLiferayComponentOp.PROP_COMPONENT_CLASS_TEMPLATE_NAME).detach(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    private NewLiferayComponentOp op() {
        return (NewLiferayComponentOp)this.context(NewLiferayComponentOp.class);
    }
}

