/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.IComponentTemplate;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import com.liferay.ide.project.core.modules.PropertyKey;
import com.liferay.ide.project.core.modules.templates.BndProperties;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.java.JavaPackageName;

public abstract class AbstractLiferayComponentTemplate
implements IComponentTemplate<NewLiferayComponentOp>,
Comparable<IComponentTemplate> {
    protected String displayName;
    protected String shortName;
    protected static final String TEMPLATE_DIR = "com/liferay/ide/project/core/modules/templates";
    protected File[] bndTemplateFiles;
    protected Configuration cfg = new Configuration();
    protected String componentClassName;
    protected File[] dependenciesTemplateFiles;
    protected ILiferayProject liferayProject;
    protected JavaPackageName packageName;
    protected IProject project;
    protected String projectName;
    protected List<String> properties = new ArrayList<String>();
    protected String serviceName;
    protected File[] sourceTemplateFiles;
    protected String templateName;
    protected String componentNameWithoutTemplateName;
    protected String modelClass;
    protected String simpleModelClass;
    private static final String[][] DEPENDENCY = new String[][]{{"com.liferay.portal", "com.liferay.portal.kernel", "2.0.0"}, {"org.osgi", "org.osgi.service.component.annotations", "1.3.0"}};

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public int compareTo(IComponentTemplate componentTemplate) {
        if (componentTemplate != null) {
            return this.displayName.compareTo(componentTemplate.getDisplayName());
        }
        return 0;
    }

    protected void createFile(IFile newFile, byte[] input) throws CoreException {
        if (newFile.getParent() instanceof IFolder) {
            CoreUtil.prepareFolder((IFolder)((IFolder)newFile.getParent()));
        }
        newFile.create((InputStream)new ByteArrayInputStream(input), true, null);
    }

    protected void createFileInResouceFolder(IFolder sourceFolder, String filePath, File resourceFile) throws CoreException {
        IFile projectFile = this.getProjectFile(sourceFolder, filePath);
        if (!projectFile.exists()) {
            String readContents = FileUtil.readContents((File)resourceFile, (boolean)true);
            this.createFile(projectFile, readContents.getBytes());
        }
    }

    protected final IPackageFragment createJavaPackage(IJavaProject javaProject, String packageName) {
        IPackageFragmentRoot packRoot = this.getSourceFolder(javaProject);
        if (packRoot == null) {
            return null;
        }
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (CoreException e) {
                ProjectCore.logError(e);
            }
        }
        return pack;
    }

    protected void createResorcesFolder(IProject project) throws CoreException {
        IFolder resourceFolder = this.liferayProject.getSourceFolder("resources");
        if (resourceFolder == null || !resourceFolder.exists()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            List<IClasspathEntry> existingRawClasspath = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>();
            IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"FROM_GRADLE_MODEL", (String)"true")};
            IClasspathEntry resourcesEntry = JavaCore.newSourceEntry((IPath)project.getFullPath().append("src/main/resources"), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IClasspathAttribute[])attributes);
            newRawClasspath.add(resourcesEntry);
            for (IClasspathEntry entry : existingRawClasspath) {
                newRawClasspath.add(entry);
            }
            javaProject.setRawClasspath(newRawClasspath.toArray(new IClasspathEntry[0]), (IProgressMonitor)new NullProgressMonitor());
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void createSampleFile(IFile newFile, String srcFileName) throws CoreException {
        try {
            URL sampleFileURL = this.getClass().getClassLoader().getResource("com/liferay/ide/project/core/modules/templates/" + srcFileName);
            String sampleContent = FileUtil.readContents((File)new File(FileLocator.toFileURL((URL)sampleFileURL).getFile()), (boolean)true);
            if (newFile.getParent() instanceof IFolder) {
                CoreUtil.prepareFolder((IFolder)((IFolder)newFile.getParent()));
            }
            newFile.create((InputStream)new ByteArrayInputStream(sampleContent.getBytes()), true, null);
        }
        catch (IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    public void createSampleFile(IFile newFile, String srcFileName, String oldReplaceConent, String newReplaceContent) throws CoreException {
        try {
            URL sampleFileURL = this.getClass().getClassLoader().getResource("com/liferay/ide/project/core/modules/templates/" + srcFileName);
            String sampleContent = FileUtil.readContents((File)new File(FileLocator.toFileURL((URL)sampleFileURL).getFile()), (boolean)true);
            String newCoentent = sampleContent.replace(oldReplaceConent, newReplaceContent);
            if (newFile.getParent() instanceof IFolder) {
                CoreUtil.prepareFolder((IFolder)((IFolder)newFile.getParent()));
            }
            newFile.create((InputStream)new ByteArrayInputStream(newCoentent.getBytes()), true, null);
        }
        catch (IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    protected void initializeOperation(NewLiferayComponentOp op) {
        this.projectName = (String)op.getProjectName().content(true);
        this.packageName = (JavaPackageName)op.getPackageName().content(true);
        this.componentClassName = (String)op.getComponentClassName().content(true);
        this.templateName = ((IComponentTemplate)op.getComponentClassTemplateName().content(true)).getShortName();
        this.serviceName = (String)op.getServiceName().content(true);
        this.modelClass = (String)op.getModelClass().content(true);
        this.componentNameWithoutTemplateName = this.componentClassName.replace(this.templateName, "");
        if (this.modelClass != null) {
            int modeClassPos = this.modelClass.lastIndexOf(".");
            this.simpleModelClass = this.modelClass.substring(modeClassPos + 1);
        }
        ElementList<PropertyKey> propertyKeys = op.getPropertyKeys();
        int i = 0;
        while (i < propertyKeys.size()) {
            PropertyKey propertyKey = (PropertyKey)propertyKeys.get(i);
            this.properties.add(String.valueOf((String)propertyKey.getName().content(true)) + "=" + (String)propertyKey.getValue().content(true) + (i != propertyKeys.size() - 1 ? "," : ""));
            ++i;
        }
    }

    @Override
    public void doExecute(NewLiferayComponentOp op, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeOperation(op);
            this.project = CoreUtil.getProject((String)this.projectName);
            if (this.project != null) {
                this.liferayProject = LiferayCore.create((Object)this.project);
                if (this.liferayProject != null) {
                    this.initFreeMarker();
                    IFile srcFile = this.prepareClassFile(this.componentClassName);
                    this.doSourceCodeOperation(srcFile);
                    this.doNewPropertiesOperation();
                    this.doMergeResourcesOperation();
                    this.doMergeBndOperation();
                    this.doMergeDependencyOperation();
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    protected void initBndProperties(File bndFile, BndProperties bndProperty) {
        try {
            bndProperty.load(bndFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setBndProperties(BndProperties bndProperty) {
    }

    protected void doMergeBndOperation() throws CoreException {
        BndProperties bndProperty = new BndProperties();
        IFile iBndFile = this.project.getFile("bnd.bnd");
        if (iBndFile.exists()) {
            File bndFile = iBndFile.getLocation().toFile();
            this.initBndProperties(bndFile, bndProperty);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileOutputStream out = new FileOutputStream(bndFile);){
                    this.setBndProperties(bndProperty);
                    bndProperty.store(out, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                ProjectCore.logError(e);
            }
        }
    }

    protected void doMergeResourcesOperation() throws CoreException {
    }

    protected void doNewPropertiesOperation() throws CoreException {
    }

    protected List<String[]> getComponentDependency() throws CoreException {
        ArrayList<String[]> dependencyList = new ArrayList<String[]>();
        String[][] stringArray = DEPENDENCY;
        int n = DEPENDENCY.length;
        int n2 = 0;
        while (n2 < n) {
            String[] dependency = stringArray[n2];
            dependencyList.add(dependency);
            ++n2;
        }
        return dependencyList;
    }

    protected void doMergeDependencyOperation() throws CoreException {
        IProjectBuilder builder = (IProjectBuilder)this.liferayProject.adapt(IProjectBuilder.class);
        builder.updateProjectDependency(this.project, this.getComponentDependency());
    }

    protected void doSourceCodeOperation(IFile srcFile) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(srcFile.getLocation().toFile());){
                Template temp = this.cfg.getTemplate(this.getTemplateFile());
                Map<String, Object> root = this.getTemplateMap();
                OutputStreamWriter out = new OutputStreamWriter(fos);
                temp.process(root, (Writer)out);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus((Exception)e));
        }
    }

    protected String getExtensionClass() {
        return null;
    }

    protected List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("org.osgi.service.component.annotations.Component");
        return imports;
    }

    protected IProject getProject() {
        return CoreUtil.getProject((String)this.projectName);
    }

    protected IFile getProjectFile(IFolder sourceFolder, String filePath) {
        IFile retval = null;
        if (sourceFolder != null) {
            retval = sourceFolder.getFile((IPath)new Path(filePath));
        }
        return retval;
    }

    protected List<String> getProperties() {
        return this.properties;
    }

    protected IPackageFragmentRoot getSourceFolder(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1) {
                    return root;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ProjectCore.logError(e);
        }
        return null;
    }

    protected String getSuperClass() {
        return null;
    }

    protected abstract String getTemplateFile();

    protected Map<String, Object> getTemplateMap() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("importlibs", this.getImports());
        root.put("properties", this.getProperties());
        root.put("packagename", this.packageName);
        root.put("classname", this.componentClassName);
        root.put("projectname", this.projectName);
        root.put("supperclass", this.getSuperClass());
        root.put("extensionclass", this.getExtensionClass());
        root.put("simplemodelclass", this.simpleModelClass);
        root.put("componentNameWithoutTemplateName", this.componentNameWithoutTemplateName);
        root.put("componentfolder", this.componentClassName.toLowerCase());
        return root;
    }

    protected void initFreeMarker() throws CoreException {
        try {
            URL templateURL = this.getClass().getClassLoader().getResource(TEMPLATE_DIR);
            this.cfg.setDirectoryForTemplateLoading(new File(FileLocator.toFileURL((URL)templateURL).getFile()));
            this.cfg.setDefaultEncoding("UTF-8");
            this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        }
        catch (IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    protected IFile prepareClassFile(String className) throws CoreException {
        IFile file = null;
        try {
            IFolder sourceFolder = this.liferayProject.getSourceFolder("java");
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            if (this.packageName != null) {
                IPackageFragment pack = this.createJavaPackage(javaProject, this.packageName.toString());
                if (pack == null) {
                    throw new CoreException(ProjectCore.createErrorStatus("Can't create package folder"));
                }
                String fileName = String.valueOf(className) + ".java";
                Path packageFullPath = new Path(this.packageName.toString().replace('.', '/'));
                if (!packageFullPath.toFile().exists()) {
                    CoreUtil.prepareFolder((IFolder)sourceFolder.getFolder((IPath)packageFullPath));
                }
                IPath javaFileFullPath = packageFullPath.append(fileName);
                file = sourceFolder.getFile(javaFileFullPath);
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
        return file;
    }
}

