/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionedSchemaRootElementController
extends StandardRootElementController {
    private final String xmlBindingPath;
    private final Pattern namespacePattern;
    private final Pattern schemaPattern;
    private final String namespaceTemplate;
    private final String schemaTemplate;
    private final String defaultVersion;
    private StandardRootElementController.RootElementInfo rootElementInfo;

    public VersionedSchemaRootElementController(String xmlBindingPath, Pattern namespacePattern, Pattern schemaPattern, String namespaceTemplate, String schemaTemplate, String defaultVersion) {
        this.xmlBindingPath = xmlBindingPath;
        this.namespacePattern = namespacePattern;
        this.schemaPattern = schemaPattern;
        this.namespaceTemplate = namespaceTemplate;
        this.schemaTemplate = schemaTemplate;
        this.defaultVersion = defaultVersion;
    }

    private Document getDocument() {
        return ((RootXmlResource)this.resource().root().adapt(RootXmlResource.class)).getDomDocument();
    }

    protected StandardRootElementController.RootElementInfo getRootElementInfo() {
        if (this.rootElementInfo == null) {
            HashMap<String, String> schemas = new HashMap<String, String>();
            Document doc = this.getDocument();
            String namespace = null;
            String uri = null;
            String location = null;
            if (doc != null) {
                Element documentElement = doc.getDocumentElement();
                if (documentElement != null) {
                    uri = documentElement.getNamespaceURI();
                    if (uri != null && this.namespacePattern.matcher(uri).matches()) {
                        namespace = uri;
                        String schema = documentElement.getAttribute("xsi:schemaLocation");
                        Matcher matcher = this.schemaPattern.matcher(schema);
                        if (schema != null && matcher.matches()) {
                            location = matcher.group(1);
                        }
                    }
                } else {
                    String version = this.defaultVersion;
                    IProject project = (IProject)this.resource().adapt(IProject.class);
                    if (project != null) {
                        version = LiferayDescriptorHelper.getDescriptorVersion(project, this.defaultVersion);
                    }
                    uri = namespace = MessageFormat.format(this.namespaceTemplate, version);
                    location = MessageFormat.format(this.schemaTemplate, version.replaceAll("\\.", "_"));
                }
            }
            schemas.put(uri, location);
            this.rootElementInfo = new StandardRootElementController.RootElementInfo(namespace, "", this.xmlBindingPath, schemas);
        }
        return this.rootElementInfo;
    }
}

