/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core;

import com.liferay.ide.core.remote.RemoteConnection;
import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoAPIException;
import java.net.URL;
import java.util.Locale;
import org.apache.http.client.methods.HttpPost;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KaleoConnection
extends RemoteConnection
implements IKaleoConnection {
    private URL portalHomeUrl;
    private String serverName;
    private String portalContextPath;

    @Override
    public JSONObject addKaleoDraftDefinition(String name, String titleMap, String definitionContent, int version, int draftVersion, long userId, long groupId) throws KaleoAPIException {
        JSONObject newKaleoDraftDefinition = null;
        HttpPost post = new HttpPost();
        try {
            Object response = this.httpJSONAPI(new Object[]{post, new Object[]{this.addKaleoDraftDefinitionAPI(), "name", name, "groupId", groupId, "titleMap", titleMap, "content", definitionContent, "version", version, "draftVersion", draftVersion, "userId", userId, "serviceContext.userId", userId}});
            if (response != null && response instanceof JSONObject) {
                JSONObject responseObject = (JSONObject)response;
                if (responseObject != null && responseObject.has("exception")) {
                    throw new KaleoAPIException(this.addKaleoDraftDefinitionAPI(), responseObject.getString("exception"));
                }
                newKaleoDraftDefinition = responseObject;
            }
        }
        catch (Exception e) {
            throw new KaleoAPIException(this.addKaleoDraftDefinitionAPI(), e);
        }
        return newKaleoDraftDefinition;
    }

    protected String addKaleoDraftDefinitionAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/add-kaleo-draft-definition";
    }

    protected String addWorkflowDefinitionKaleoDraftDefinitionAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/add-workflow-definition-kaleo-draft-definition";
    }

    private String getPortalContextPath() {
        return this.portalContextPath;
    }

    private String getCompanyByVirtualHostAPI() {
        return String.valueOf(this.getPortalContextPath()) + "/api/jsonws/company/get-company-by-virtual-host";
    }

    @Override
    public JSONObject getCompanyIdByVirtualHost() throws KaleoAPIException {
        JSONObject company = null;
        KaleoAPIException apiException = null;
        try {
            Object response = this.getJSONAPI(new Object[]{this.getCompanyByVirtualHostAPI(), "virtualHost", this.getHost()});
            if (response != null && response instanceof JSONObject) {
                company = (JSONObject)response;
            }
        }
        catch (Exception e) {
            apiException = new KaleoAPIException(this.getKaleoDefinitionsAPI(), e);
        }
        if (company == null) {
            throw new KaleoAPIException(this.getCompanyByVirtualHostAPI(), apiException);
        }
        return company;
    }

    @Override
    public JSONArray getKaleoDefinitions() throws KaleoAPIException {
        JSONArray definitions = null;
        KaleoAPIException apiException = null;
        Object response = null;
        try {
            response = this.getJSONAPI(new Object[]{String.valueOf(this.getKaleoDefinitionsAPI()) + "/start/-1/end/-1"});
            if (response != null && response instanceof JSONArray) {
                definitions = (JSONArray)response;
            }
        }
        catch (Exception e) {
            apiException = new KaleoAPIException(this.getKaleoDefinitionsAPI(), e);
        }
        if (definitions == null) {
            throw new KaleoAPIException(this.getKaleoDefinitionsAPI(), apiException);
        }
        return definitions;
    }

    protected String getKaleoDefinitionsAPI() {
        return String.valueOf(this.getKaleoWebAPIUrl()) + "/kaleo.kaleodefinition/get-kaleo-definitions";
    }

    private String getKaleoDesignerAPIUrl() {
        return "/api/jsonws";
    }

    protected String getKaleoDraftDefinitionsAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/get-kaleo-draft-definitions";
    }

    @Override
    public JSONArray getKaleoDraftWorkflowDefinitions() throws KaleoAPIException {
        JSONArray definitions = null;
        KaleoAPIException apiException = null;
        Object response = null;
        try {
            response = this.getJSONAPI(new Object[]{this.getKaleoDraftDefinitionsAPI()});
            if (response != null && response instanceof JSONArray) {
                definitions = (JSONArray)response;
            }
        }
        catch (Exception e) {
            apiException = new KaleoAPIException(this.getKaleoDraftDefinitionsAPI(), e);
        }
        if (definitions == null) {
            throw new KaleoAPIException(this.getKaleoDraftDefinitionsAPI(), apiException);
        }
        return definitions;
    }

    private String getKaleoWebAPIUrl() {
        return "/api/jsonws";
    }

    @Override
    public JSONObject getLatestKaleoDraftDefinition(String name, int version, long companyId) throws KaleoAPIException {
        Object latestDraftDefinition = null;
        KaleoAPIException apiException = null;
        try {
            Object response = this.getJSONAPI(new Object[]{this.getLatestKaleoDraftDefinitionAPI(), "name", name, "version", version, "serviceContext.companyId", companyId});
            if (response != null && response instanceof JSONObject) {
                JSONObject responseObject = (JSONObject)response;
                latestDraftDefinition = responseObject != null && responseObject.has("exception") ? null : responseObject;
            }
        }
        catch (Exception e) {
            apiException = new KaleoAPIException(this.getLatestKaleoDraftDefinitionAPI(), e);
        }
        if (apiException != null) {
            throw new KaleoAPIException(this.getLatestKaleoDraftDefinitionAPI(), apiException);
        }
        return latestDraftDefinition;
    }

    protected String getLatestKaleoDraftDefinitionAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/get-latest-kaleo-draft-definition";
    }

    private String getPortalAPIUrl() {
        return "/api/jsonws";
    }

    public URL getPortalHtmlUrl() {
        return this.portalHomeUrl;
    }

    @Override
    public String getPortalLocale(long userId) throws KaleoAPIException {
        JSONObject user = this.getPortalUserById(userId);
        String portalDefaultLocale = Locale.getDefault().toString();
        if (user != null) {
            try {
                portalDefaultLocale = user.getString("languageId");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return portalDefaultLocale;
    }

    protected String getPortalUserAPI() {
        return String.valueOf(this.getPortalAPIUrl()) + "/user/get-user-by-id";
    }

    @Override
    public JSONObject getPortalUserById(long userId) throws KaleoAPIException {
        JSONObject user = null;
        HttpPost post = new HttpPost();
        try {
            Object response = this.httpJSONAPI(new Object[]{post, new Object[]{this.getPortalUserAPI(), "userId", userId}});
            if (response != null && response instanceof JSONObject) {
                JSONObject responseObject = (JSONObject)response;
                if (responseObject != null && responseObject.has("exception")) {
                    throw new KaleoAPIException(this.addKaleoDraftDefinitionAPI(), responseObject.getString("exception"));
                }
                user = responseObject;
            }
        }
        catch (Exception e) {
            throw new KaleoAPIException(this.addKaleoDraftDefinitionAPI(), e);
        }
        return user;
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public JSONObject getUserByEmailAddress() throws KaleoAPIException {
        JSONObject user = null;
        KaleoAPIException apiException = null;
        try {
            Object response = this.getJSONAPI(new Object[]{this.getUserByEmailAddressAPI(), "companyId", this.getCompanyIdByVirtualHost().getLong("companyId"), "emailAddress", this.getUsername()});
            if (response != null && response instanceof JSONObject) {
                user = (JSONObject)response;
            }
        }
        catch (Exception e) {
            apiException = new KaleoAPIException(this.getUserByEmailAddressAPI(), e);
        }
        if (user == null) {
            throw new KaleoAPIException(this.getUserByEmailAddressAPI(), apiException);
        }
        return user;
    }

    public String getUserByEmailAddressAPI() {
        return String.valueOf(this.getPortalAPIUrl()) + "/user/get-user-by-email-address";
    }

    @Override
    public void publishKaleoDraftDefinition(String name, String titleMap, String content, String companyId, String userId, String groupId) throws KaleoAPIException {
        try {
            JSONObject responseObject;
            HttpPost httpPost = new HttpPost();
            Object response = this.httpJSONAPI(new Object[]{httpPost, new Object[]{this.publishKaleoDraftDefinitionAPI(), "name", name, "titleMap", titleMap, "content", content, "userId", userId, "groupId", groupId, "serviceContext.companyId", companyId, "serviceContext.userId", userId}});
            if (response != null && response instanceof JSONObject && (responseObject = (JSONObject)response) != null && responseObject.has("exception")) {
                throw new KaleoAPIException(this.publishKaleoDraftDefinitionAPI(), responseObject.getString("exception"));
            }
        }
        catch (Exception e) {
            throw new KaleoAPIException(this.publishKaleoDraftDefinitionAPI(), e);
        }
    }

    protected String publishKaleoDraftDefinitionAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/publish-kaleo-draft-definition";
    }

    @Override
    public void setPortalHtmlUrl(URL portalHomeUrl) {
        this.portalHomeUrl = portalHomeUrl;
    }

    @Override
    public void setPortalContextPath(String portalContextPath) {
        this.portalContextPath = portalContextPath;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public JSONObject updateKaleoDraftDefinition(String name, String titleMap, String content, int version, int draftVersion, long companyId, long userId) throws KaleoAPIException {
        JSONObject updatedKaleoDraftDefinition = null;
        try {
            HttpPost post = new HttpPost();
            Object response = this.httpJSONAPI(new Object[]{post, new Object[]{this.updateKaleoDraftDefinitionAPI(), "name", name, "titleMap", titleMap, "content", content, "version", version, "draftVersion", draftVersion, "userId", userId, "serviceContext.companyId", companyId, "serviceContext.userId", userId}});
            if (response != null && response instanceof JSONObject) {
                JSONObject responseObject = (JSONObject)response;
                if (responseObject != null && responseObject.has("exception")) {
                    throw new KaleoAPIException(this.addWorkflowDefinitionKaleoDraftDefinitionAPI(), responseObject.getString("exception"));
                }
                updatedKaleoDraftDefinition = responseObject;
            }
        }
        catch (Exception e) {
            throw new KaleoAPIException(this.publishKaleoDraftDefinitionAPI(), e);
        }
        return updatedKaleoDraftDefinition;
    }

    protected String updateKaleoDraftDefinitionAPI() {
        return String.valueOf(this.getKaleoDesignerAPIUrl()) + "/kaleodesigner.kaleodraftdefinition/update-kaleo-draft-definition";
    }
}

